/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.google.common.collect.ImmutableList;
import com.mcmoddev.orespawn.api.os3.DimensionBuilder;
import com.mcmoddev.orespawn.api.os3.SpawnBuilder;
import com.mcmoddev.orespawn.impl.os3.SpawnBuilderImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DimensionBuilderImpl
implements DimensionBuilder {
    private static final String UNNAMED = "unnamed";
    private Map<String, List<SpawnBuilder>> spawns = new HashMap<String, List<SpawnBuilder>>();

    @Override
    public SpawnBuilder newSpawnBuilder(@Nullable String name) {
        String entName = name == null ? UNNAMED : name;
        this.spawns.computeIfAbsent(entName, tempName -> new ArrayList());
        SpawnBuilderImpl sb = new SpawnBuilderImpl();
        this.spawns.get(entName).add(sb);
        return sb;
    }

    @Override
    public DimensionBuilder create(SpawnBuilder ... addedSpawns) {
        return this;
    }

    @Override
    public ImmutableList<SpawnBuilder> getSpawnByName(String name) {
        if (this.spawns.containsKey(name)) {
            return ImmutableList.copyOf((Collection)this.spawns.get(name));
        }
        return null;
    }

    @Override
    public ImmutableList<SpawnBuilder> getAllSpawns() {
        return ImmutableList.copyOf((Collection)((Collection)this.spawns.values().stream().collect(Collectors.toList()).get(0)));
    }
}

