/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.google.common.collect.ImmutableMap;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.os3.BuilderLogic;
import com.mcmoddev.orespawn.api.os3.DimensionBuilder;
import com.mcmoddev.orespawn.api.os3.OS3API;
import com.mcmoddev.orespawn.api.os3.SpawnBuilder;
import com.mcmoddev.orespawn.data.ReplacementsRegistry;
import com.mcmoddev.orespawn.impl.os3.BuilderLogicImpl;
import com.mcmoddev.orespawn.util.OS3V2PresetStorage;
import com.mcmoddev.orespawn.worldgen.OreSpawnWorldGen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class OS3APIImpl
implements OS3API {
    private final Map<String, BuilderLogic> logic = new HashMap<String, BuilderLogic>();
    private OreSpawnWorldGen generator;
    private OS3V2PresetStorage presets = new OS3V2PresetStorage();

    @Override
    public void registerReplacementBlock(String name, Block itemBlock) {
        this.registerReplacementBlock(name, itemBlock.func_176223_P());
    }

    @Override
    public void registerReplacementBlock(String name, IBlockState itemBlock) {
        ReplacementsRegistry.addBlock(name, itemBlock);
    }

    @Override
    public void registerFeatureGenerator(String name, String className) {
        OreSpawn.FEATURES.addFeature(name, className);
    }

    @Override
    public void registerFeatureGenerator(String name, IFeature feature) {
        this.registerFeatureGenerator(name, feature.getClass().getName());
    }

    @Override
    public void registerFeatureGenerator(String name, Class<? extends IFeature> feature) {
        this.registerFeatureGenerator(name, feature.getName());
    }

    @Override
    public BuilderLogic getLogic(String name) {
        if (this.logic.containsKey(name)) {
            return this.logic.get(name);
        }
        BuilderLogicImpl bl = new BuilderLogicImpl();
        this.logic.put(name, bl);
        return bl;
    }

    @Override
    public void registerLogic(BuilderLogic logic) {
    }

    @Override
    public int dimensionWildcard() {
        return -889275714;
    }

    @Override
    public int biomeWildcard() {
        return -267522035;
    }

    @Override
    public ImmutableMap<String, BuilderLogic> getSpawns() {
        return ImmutableMap.copyOf(this.logic);
    }

    @Override
    public void registerSpawns() {
        Map<Integer, List<SpawnBuilder>> spawns = OreSpawn.getSpawns();
        for (Map.Entry<String, BuilderLogic> ent : this.logic.entrySet()) {
            for (Map.Entry dL : ent.getValue().getAllDimensions().entrySet()) {
                if (spawns.containsKey(dL.getKey())) {
                    spawns.get(dL.getKey()).addAll((Collection<SpawnBuilder>)((DimensionBuilder)dL.getValue()).getAllSpawns());
                    continue;
                }
                spawns.put((Integer)dL.getKey(), new ArrayList());
                spawns.get(dL.getKey()).addAll((Collection<SpawnBuilder>)((DimensionBuilder)dL.getValue()).getAllSpawns());
            }
            OreSpawn.LOGGER.info("Registered spawn logic from data-file (maybe mod) %s", (Object)ent.getKey());
        }
        Random random = new Random();
        this.generator = new OreSpawnWorldGen(spawns, random.nextLong());
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.generator, (int)100);
    }

    @Override
    public OreSpawnWorldGen getGenerator() {
        return this.generator;
    }

    @Override
    public OS3V2PresetStorage getPresets() {
        return this.presets;
    }
}

