/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.api.os3.BiomeBuilder;
import com.mcmoddev.orespawn.api.os3.DimensionList;
import com.mcmoddev.orespawn.api.os3.FeatureBuilder;
import com.mcmoddev.orespawn.api.os3.OreBuilder;
import com.mcmoddev.orespawn.api.os3.SpawnBuilder;
import com.mcmoddev.orespawn.impl.os3.BiomeBuilderImpl;
import com.mcmoddev.orespawn.impl.os3.DimensionListImpl;
import com.mcmoddev.orespawn.impl.os3.FeatureBuilderImpl;
import com.mcmoddev.orespawn.impl.os3.OreBuilderImpl;
import com.mcmoddev.orespawn.util.OreList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.lang3.ArrayUtils;

public class SpawnBuilderImpl
implements SpawnBuilder {
    private BiomeLocation biomeLocs = null;
    private FeatureBuilder featureGen = null;
    private List<IBlockState> replacementBlocks = new ArrayList<IBlockState>();
    private List<OreBuilder> myOres = new ArrayList<OreBuilder>();
    private OreList oreList;
    private boolean enabled = true;
    private boolean retrogen = false;
    private boolean extendedDimensionsBool = false;
    private DimensionList extendedDimensions;

    SpawnBuilderImpl() {
    }

    @Override
    public FeatureBuilder newFeatureBuilder(@Nullable String featureName) {
        this.featureGen = new FeatureBuilderImpl();
        String featName = OreSpawn.FEATURES.getFeature(featureName) == null || featureName == null ? "default" : featureName;
        this.featureGen.setGenerator(featName);
        return this.featureGen;
    }

    @Override
    public BiomeBuilder newBiomeBuilder() {
        return new BiomeBuilderImpl();
    }

    @Override
    public OreBuilder newOreBuilder() {
        return new OreBuilderImpl();
    }

    @Override
    public SpawnBuilder create(@Nonnull BiomeBuilder biomes, @Nonnull FeatureBuilder feature, @Nonnull List<IBlockState> replacements, OreBuilder ... ores) {
        this.biomeLocs = biomes.getBiomes();
        this.featureGen = feature;
        this.replacementBlocks.addAll(replacements);
        if (ores.length > 1) {
            this.myOres.addAll(Arrays.asList(ores));
        } else {
            this.myOres.add(ores[0]);
        }
        return this;
    }

    @Override
    public SpawnBuilder create(@Nonnull BiomeBuilder biomes, @Nonnull FeatureBuilder feature, @Nonnull List<IBlockState> replacements, JsonObject exDim, OreBuilder ... ores) {
        this.create(biomes, feature, replacements, ores);
        this.setupDimensionWhitelist(exDim);
        return this;
    }

    private void setupDimensionWhitelist(JsonObject exDim) {
        JsonArray whitelist = exDim.getAsJsonArray("includes");
        JsonArray blacklist = exDim.getAsJsonArray("excludes");
        ArrayList tempW = new ArrayList();
        ArrayList tempB = new ArrayList();
        if (whitelist != null) {
            whitelist.forEach(it -> tempW.add(it.getAsInt()));
        }
        if (blacklist != null) {
            blacklist.forEach(it -> tempB.add(it.getAsInt()));
        }
        this.extendedDimensionsBool = true;
        this.extendedDimensions = new DimensionListImpl();
        this.extendedDimensions.create(ArrayUtils.toPrimitive((Integer[])tempW.toArray(new Integer[0])), ArrayUtils.toPrimitive((Integer[])tempB.toArray(new Integer[0])));
    }

    @Override
    public BiomeLocation getBiomes() {
        return this.biomeLocs;
    }

    @Override
    public ImmutableList<OreBuilder> getOres() {
        return ImmutableList.copyOf(this.myOres);
    }

    @Override
    public ImmutableList<IBlockState> getReplacementBlocks() {
        return ImmutableList.copyOf(this.replacementBlocks);
    }

    @Override
    public FeatureBuilder getFeatureGen() {
        return this.featureGen;
    }

    private void buildSpawnList() {
        if (this.oreList != null) {
            return;
        }
        this.oreList = new OreList();
        this.oreList.build(Collections.unmodifiableList(this.myOres));
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean retrogen() {
        return this.retrogen;
    }

    @Override
    public void retrogen(boolean enabled) {
        this.retrogen = enabled;
    }

    @Override
    public boolean hasExtendedDimensions() {
        return this.extendedDimensionsBool;
    }

    @Override
    public boolean extendedDimensionsMatch(int dimension) {
        return !this.extendedDimensionsBool || this.extendedDimensions.match(dimension);
    }

    @Override
    public OreBuilder getRandomOre(Random rand) {
        if (this.oreList == null) {
            this.buildSpawnList();
        }
        return this.oreList.getRandomOre(rand);
    }

    @Override
    public OreList getOreSpawns() {
        if (this.oreList == null) {
            this.buildSpawnList();
        }
        return this.oreList;
    }
}

