/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.common.base.Charsets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.os3.BiomeBuilder;
import com.mcmoddev.orespawn.api.os3.BuilderLogic;
import com.mcmoddev.orespawn.api.os3.DimensionBuilder;
import com.mcmoddev.orespawn.api.os3.FeatureBuilder;
import com.mcmoddev.orespawn.api.os3.OreBuilder;
import com.mcmoddev.orespawn.api.os3.SpawnBuilder;
import com.mcmoddev.orespawn.data.ReplacementsRegistry;
import com.mcmoddev.orespawn.json.Replacements;
import com.mcmoddev.orespawn.json.os3.IOS3Reader;
import com.mcmoddev.orespawn.json.os3.readers.Helpers;
import com.mcmoddev.orespawn.json.os3.readers.OS3V1Reader;
import com.mcmoddev.orespawn.json.os3.readers.OS3V2Reader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.item.Item;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class OS3Reader {
    private OS3Reader() {
    }

    private static void loadFeatures(File file) {
        OreSpawn.FEATURES.loadFeaturesFile(file);
    }

    public static void loadEntries() {
        File directory = new File("config", "orespawn3");
        JsonParser parser = new JsonParser();
        if (!directory.exists()) {
            directory.mkdirs();
            return;
        }
        if (!directory.isDirectory()) {
            OreSpawn.LOGGER.fatal("OreSpawn data directory inaccessible - " + directory + " is not a directory!");
            return;
        }
        File[] files = directory.listFiles();
        if (files.length == 0) {
            return;
        }
        Path presets = Paths.get("config", "orespawn3", "sysconf", "presets.json");
        OS3Reader.loadPresets(presets);
        if (Paths.get("config", "orespawn3", "sysconf").toFile().exists() && Paths.get("config", "orespawn3", "sysconf").toFile().isDirectory()) {
            Arrays.stream(Paths.get("config", "orespawn3", "sysconf").toFile().listFiles()).filter(file -> "json".equals(FilenameUtils.getExtension((String)file.getName()))).forEach(file -> {
                String filename = file.getName();
                if (FilenameUtils.getBaseName((String)filename).matches("features-.+")) {
                    OS3Reader.loadFeatures(file);
                } else if (FilenameUtils.getBaseName((String)filename).matches("replacements-.+")) {
                    Replacements.load(file);
                }
            });
        }
        Arrays.stream(files).filter(file -> file.getName().endsWith(".json")).forEach(file -> {
            try {
                String rawData = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
                if (rawData.isEmpty()) {
                    return;
                }
                JsonElement full = parser.parse(rawData);
                JsonObject parsed = full.getAsJsonObject();
                String version = parsed.get("version").getAsString();
                IOS3Reader reader = OS3Reader.getReader(version);
                if (reader != null) {
                    OS3Reader.finallyParse(reader.parseJson(parsed, FilenameUtils.getBaseName((String)file.getName())), FilenameUtils.getBaseName((String)file.getName()));
                }
            }
            catch (Exception e) {
                CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + file.getName()));
                report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.2.2");
                OreSpawn.LOGGER.info(report.func_71502_e());
            }
        });
    }

    private static void loadPresets(Path presets) {
        if (presets.toFile().exists()) {
            try {
                JsonParser parser = new JsonParser();
                String rawJson = FileUtils.readFileToString((File)presets.toFile(), (Charset)Charsets.UTF_8);
                JsonObject top = parser.parse(rawJson).getAsJsonObject();
                top.entrySet().forEach(entry -> {
                    String section = (String)entry.getKey();
                    ((JsonElement)entry.getValue()).getAsJsonObject().entrySet().forEach(pres -> OreSpawn.API.getPresets().setSymbolSection(section, (String)pres.getKey(), (JsonElement)pres.getValue()));
                });
            }
            catch (IOException exc) {
                CrashReport report = CrashReport.func_85055_a((Throwable)exc, (String)("Failed reading presets " + presets.toFile().getName()));
                report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.2.2");
                OreSpawn.LOGGER.info(report.func_71502_e());
            }
            catch (JsonParseException ex) {
                CrashReport report = CrashReport.func_85055_a((Throwable)ex, (String)("Failed loading or parsing " + presets.toFile().getName()));
                report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.2.2");
                OreSpawn.LOGGER.info(report.func_71502_e());
            }
        }
    }

    private static void finallyParse(JsonObject parseJson, String filename) {
        JsonObject work = parseJson.getAsJsonObject("dimensions");
        BuilderLogic logic = OreSpawn.API.getLogic(filename);
        work.entrySet().forEach(entry -> {
            int dimension = Integer.parseInt((String)entry.getKey());
            DimensionBuilder builder = logic.newDimensionBuilder(dimension);
            ((JsonElement)entry.getValue()).getAsJsonArray().forEach(ore -> {
                try {
                    JsonObject nw = ore.getAsJsonObject();
                    SpawnBuilder spawn = builder.newSpawnBuilder(null);
                    List<OreBuilder> blocks = Helpers.loadOres(nw.getAsJsonArray("blocks"), spawn);
                    List<IBlockState> replacements = OS3Reader.getReplacements(nw.get("replaces").getAsString(), dimension);
                    BiomeBuilder biomes = spawn.newBiomeBuilder();
                    if (nw.get("biomes").isJsonObject()) {
                        biomes.setFromBiomeLocation(Helpers.deserializeBiomeLocationComposition(nw.getAsJsonObject("biomes")));
                    }
                    FeatureBuilder gen = spawn.newFeatureBuilder(nw.get("feature").getAsString());
                    gen.setDefaultParameters();
                    OS3Reader.handleParameterFixes(nw);
                    gen.setParameters(nw.getAsJsonObject("parameters"));
                    spawn.enabled(nw.get("enabled").getAsBoolean());
                    spawn.retrogen(nw.get("retrogen").getAsBoolean());
                    if (nw.has("dimension")) {
                        OreSpawn.LOGGER.fatal("Entry has %s tag with contents: %s", (Object)"dimension", (Object)nw.getAsJsonObject("dimension"));
                        spawn.create(biomes, gen, replacements, nw.getAsJsonObject("dimension"), blocks.toArray(new OreBuilder[0]));
                    } else {
                        spawn.create(biomes, gen, replacements, blocks.toArray(new OreBuilder[0]));
                    }
                    builder.create(spawn);
                }
                catch (JsonParseException ex) {
                    OreSpawn.LOGGER.error("Error parsing entry %s : %s", (Object)ore.getAsJsonObject().get("name").getAsString(), (Object)ex);
                }
                catch (NullPointerException npe) {
                    OreSpawn.LOGGER.error("Exception parsing entry %s : possibly mis-named or missing item ?", (Object)ore.getAsJsonObject().get("name").getAsString());
                }
            });
            logic.create(builder);
        });
    }

    private static void handleParameterFixes(JsonObject nw) {
        JsonObject p = nw.getAsJsonObject("parameters");
        if (p.has("attempts")) {
            if (p.get("attempts").isJsonObject()) {
                p.add("minAttempts", p.getAsJsonObject("attempts").get("minimum"));
                p.add("maxAttempts", p.getAsJsonObject("attempts").get("maximum"));
            } else {
                p.addProperty("minAttempts", (Number)p.get("attempts").getAsInt());
                p.addProperty("maxAttempts", (Number)p.get("attempts").getAsInt());
            }
            p.remove("attempts");
            nw.remove("parameters");
            nw.add("parameters", (JsonElement)p);
        }
    }

    private static List<IBlockState> getReplacements(String configField, int dimension) {
        String work = configField.toLowerCase();
        if (work.equals("default")) {
            return ReplacementsRegistry.getDimensionDefault(dimension);
        }
        if (work.startsWith("ore:")) {
            NonNullList ores = OreDictionary.getOres((String)work.substring(4));
            ArrayList<IBlockState> reps = new ArrayList<IBlockState>();
            ores.forEach(ore -> reps.add(Block.func_149634_a((Item)ore.func_77973_b()).func_176223_P()));
            return reps;
        }
        if (!work.contains(":")) {
            return Arrays.asList(ReplacementsRegistry.getBlock(work));
        }
        return Arrays.asList(((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(configField))).func_176223_P());
    }

    public static IOS3Reader getReader(String version) {
        switch (version) {
            case "1": 
            case "1.1": 
            case "1.2": {
                return new OS3V1Reader();
            }
            case "2.0": {
                return new OS3V2Reader();
            }
        }
        OreSpawn.LOGGER.error("Unknown version %s", (Object)version);
        return null;
    }
}

