/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.api.os3.BuilderLogic;
import com.mcmoddev.orespawn.api.os3.DimensionBuilder;
import com.mcmoddev.orespawn.api.os3.OreBuilder;
import com.mcmoddev.orespawn.api.os3.SpawnBuilder;
import com.mcmoddev.orespawn.impl.location.BiomeLocationComposition;
import com.mcmoddev.orespawn.impl.location.BiomeLocationDictionary;
import com.mcmoddev.orespawn.impl.location.BiomeLocationList;
import com.mcmoddev.orespawn.impl.location.BiomeLocationSingle;
import com.mcmoddev.orespawn.json.Replacements;
import com.mcmoddev.orespawn.util.StateUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import net.minecraft.crash.CrashReport;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FileUtils;

public class OS3Writer {
    private void writeFeatures(String base) {
        File file = new File(Paths.get(base, "sysconf").toString(), "features-default.json");
        OreSpawn.FEATURES.writeFeatures(file);
    }

    private void writeReplacements(String base) {
        File file = new File(Paths.get(base, "sysconf").toString(), "replacements-default.json");
        Replacements.save(file);
    }

    public void writeSpawnEntries() {
        String basePath = Paths.get("config", "orespawn3", "force-written").toString();
        this.writeFeatures(basePath);
        this.writeReplacements(basePath);
        OreSpawn.API.getSpawns().entrySet().forEach(ent -> {
            JsonArray dimensions = new JsonArray();
            for (Map.Entry dim : ((BuilderLogic)ent.getValue()).getAllDimensions().entrySet()) {
                JsonArray spawns;
                JsonObject dimension = new JsonObject();
                if (((Integer)dim.getKey()).intValue() != OreSpawn.API.dimensionWildcard()) {
                    dimension.addProperty("dimension", String.format("%d", dim.getKey()));
                }
                if ((spawns = this.genSpawns(((DimensionBuilder)dim.getValue()).getAllSpawns())).size() <= 0) continue;
                dimension.add("ores", (JsonElement)spawns);
                dimensions.add((JsonElement)dimension);
            }
            if (this.countOres(dimensions) > 0) {
                File file = new File(basePath, String.format("%s.json", ent.getKey()));
                JsonObject wrapper = new JsonObject();
                wrapper.addProperty("version", "1.2");
                wrapper.add("dimensions", (JsonElement)dimensions);
                this.writeFile(file, wrapper);
            }
        });
    }

    private JsonArray genSpawns(ImmutableList<SpawnBuilder> allSpawns) {
        JsonArray rv = new JsonArray();
        for (SpawnBuilder spawn : allSpawns) {
            if (spawn.getOres().isEmpty() || ((OreBuilder)spawn.getOres().get(0)).getOre() == null || "minecraft:air".equals(((OreBuilder)spawn.getOres().get(0)).getOre().func_177230_c().getRegistryName().toString())) continue;
            rv.add((JsonElement)this.genSpawn(spawn));
        }
        return rv;
    }

    private void writeFile(File file, JsonObject wrapper) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            FileUtils.writeStringToFile((File)file, (String)gson.toJson((JsonElement)wrapper), (String)"UTF8", (boolean)false);
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)String.format("Failed in config %s", file.getName()));
            report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.2.2");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
    }

    private JsonObject genSpawn(SpawnBuilder spawn) {
        JsonObject ore = new JsonObject();
        ore.add("blocks", (JsonElement)this.genBlocks(spawn.getOres()));
        ore.add("parameters", (JsonElement)spawn.getFeatureGen().getParameters());
        ore.addProperty("feature", spawn.getFeatureGen().getFeatureName());
        ore.addProperty("replace_block", "default");
        ore.add("biomes", this.biomeLocationToJsonObject(spawn.getBiomes()));
        return ore;
    }

    private JsonArray genBlocks(ImmutableList<OreBuilder> ores) {
        JsonArray retval = new JsonArray();
        ores.forEach(ore -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("block", ore.getOre().func_177230_c().getRegistryName().toString());
            obj.addProperty("state", StateUtil.serializeState(ore.getOre()));
            obj.addProperty("chance", (Number)ore.getChance());
            retval.add((JsonElement)obj);
        });
        return retval;
    }

    private int countOres(JsonArray dims) {
        int count = 0;
        for (JsonElement dim : dims) {
            count += dim.getAsJsonObject().get("ores").getAsJsonArray().size();
        }
        return count;
    }

    private JsonElement biomeLocationToJsonObject(BiomeLocation value) {
        if (value instanceof BiomeLocationSingle || value instanceof BiomeLocationDictionary) {
            return this.getString(value);
        }
        if (value instanceof BiomeLocationList) {
            return this.getList(value);
        }
        if (value instanceof BiomeLocationComposition) {
            return this.getComposition(value);
        }
        return null;
    }

    private JsonElement getComposition(BiomeLocation value) {
        JsonObject rv = new JsonObject();
        rv.add("includes", (JsonElement)this.getList(new BiomeLocationList(((BiomeLocationComposition)value).getInclusions())));
        rv.add("excludes", (JsonElement)this.getList(new BiomeLocationList(((BiomeLocationComposition)value).getExclusions())));
        return rv;
    }

    private JsonArray getList(BiomeLocation value) {
        JsonArray rv = new JsonArray();
        ((BiomeLocationList)value).getLocations().forEach(loc -> {
            if (loc instanceof BiomeLocationSingle || loc instanceof BiomeLocationDictionary) {
                rv.add(this.getString((BiomeLocation)loc));
            } else if (loc instanceof BiomeLocationComposition) {
                rv.add(this.getComposition((BiomeLocation)loc));
            }
        });
        return rv;
    }

    private JsonElement getString(BiomeLocation value) {
        String val = null;
        val = value instanceof BiomeLocationSingle ? ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)((BiomeLocationSingle)value).getBiome()).toString() : ((BiomeLocationDictionary)value).getType().toString();
        return new JsonPrimitive(val);
    }

    public void writeSysconfIfNonexistent() {
        String base = String.format(".%1$sconfig%1$sorespawn3", File.separator);
        if (!Paths.get(base, "sysconf", "features-default.json").toFile().exists()) {
            this.writeFeatures(base);
        }
        if (!Paths.get(base, "sysconf", "replacements-default.json").toFile().exists()) {
            this.writeReplacements(base);
        }
    }

    public void writeAddOreEntry(String fileName) {
        BuilderLogic ent = OreSpawn.API.getLogic(fileName);
        JsonArray dimensions = new JsonArray();
        for (Map.Entry dim : ent.getAllDimensions().entrySet()) {
            JsonArray spawns;
            JsonObject dimension = new JsonObject();
            if (((Integer)dim.getKey()).intValue() != OreSpawn.API.dimensionWildcard()) {
                dimension.addProperty("dimension", String.format("%d", dim.getKey()));
            }
            if ((spawns = this.genSpawns(((DimensionBuilder)dim.getValue()).getAllSpawns())).size() <= 0) continue;
            dimension.add("ores", (JsonElement)spawns);
            dimensions.add((JsonElement)dimension);
        }
        if (this.countOres(dimensions) > 0) {
            Path p = Paths.get("config", "orespawn3", "force-written");
            if (!p.toFile().exists()) {
                p.toFile().mkdirs();
            }
            File file = Paths.get(p.toString(), String.format("%s-addOre.json", fileName)).toFile();
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty("version", "1.2");
            wrapper.add("dimensions", (JsonElement)dimensions);
            this.writeFile(file, wrapper);
        }
    }
}

