/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.json.OS3Reader;
import com.mcmoddev.orespawn.json.Replacements;
import com.mcmoddev.orespawn.json.os3.IOS3Reader;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.crash.CrashReport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class OreSpawnReader {
    private List<JsonObject> spawns = new LinkedList<JsonObject>();

    public void loadSpawnData() {
        this.parseSpawnsV3();
    }

    private void parseSpawnsV3() {
        File directory = new File("config", "orespawn3");
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            OreSpawn.LOGGER.fatal("OreSpawn data directory inaccessible - " + directory + " is not a directory!");
            return;
        }
        File[] files = directory.listFiles();
        if (files.length == 0) {
            return;
        }
        this.loadFeaturesAndReplacements();
        this.loadSpawns(files);
    }

    private void loadSpawns(File[] files) {
        JsonParser parser = new JsonParser();
        Arrays.stream(files).filter(file -> file.getName().endsWith(".json")).forEach(file -> {
            try {
                String rawData = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
                if (rawData.isEmpty()) {
                    return;
                }
                JsonElement full = parser.parse(rawData);
                JsonObject parsed = full.getAsJsonObject();
                String version = parsed.get("version").getAsString();
                IOS3Reader reader = OS3Reader.getReader(version);
                this.spawns.add(reader.parseJson(parsed, file.getName().substring(0, file.getName().lastIndexOf(46))));
            }
            catch (Exception e) {
                CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + file.getName()));
                report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.2.2");
                OreSpawn.LOGGER.info(report.func_71502_e());
            }
        });
    }

    private void loadFeaturesAndReplacements() {
        if (Paths.get("config", "orespawn3", "sysconf").toFile().exists() && Paths.get("config", "orespawn3", "sysconf").toFile().isDirectory()) {
            Arrays.stream(Paths.get("config", "orespawn3", "sysconf").toFile().listFiles()).filter(file -> "json".equals(FilenameUtils.getExtension((String)file.getName()))).forEach(file -> {
                String filename = file.getName();
                if (FilenameUtils.getBaseName((String)filename).matches("features-.+")) {
                    OreSpawn.FEATURES.loadFeaturesFile((File)file);
                } else if (FilenameUtils.getBaseName((String)filename).matches("replacements-.+")) {
                    Replacements.load(file);
                }
            });
        }
    }
}

