/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.data.ReplacementsRegistry;
import com.mcmoddev.orespawn.util.StateUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class Replacements {
    private Replacements() {
    }

    public static void load(File file) {
        JsonParser parser = new JsonParser();
        String rawJson = "[]";
        try {
            rawJson = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + file.getName()));
            report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.2.2");
            OreSpawn.LOGGER.info(report.func_71502_e());
            return;
        }
        JsonArray elements = parser.parse(rawJson).getAsJsonArray();
        for (JsonElement elem : elements) {
            JsonObject obj = elem.getAsJsonObject();
            String name = obj.get("name").getAsString();
            String blockName = obj.get("blockName").getAsString();
            String blockState = obj.get("blockState").getAsString();
            ReplacementsRegistry.addBlock(name, blockName, blockState);
        }
    }

    public static void save(File file) {
        Map<String, IBlockState> blocks = ReplacementsRegistry.getBlocks();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (blocks != null) {
            JsonArray root = new JsonArray();
            for (Map.Entry<String, IBlockState> block : blocks.entrySet()) {
                JsonObject entry = new JsonObject();
                entry.addProperty("name", block.getKey());
                entry.addProperty("blockName", block.getValue().func_177230_c().getRegistryName().toString());
                entry.addProperty("blockState", StateUtil.serializeState(block.getValue()));
                root.add((JsonElement)entry);
            }
            String json = gson.toJson((JsonElement)root);
            try {
                FileUtils.writeStringToFile((File)file, (String)StringEscapeUtils.unescapeJson((String)json), (String)"UTF-8");
            }
            catch (IOException e) {
                OreSpawn.LOGGER.fatal("Error writing " + file.toString() + " - " + e.getLocalizedMessage());
            }
        }
    }
}

