/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json.os3;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.util.OS3V2PresetStorage;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

public interface IOS3Reader {
    default public OS3V2PresetStorage getStorage() {
        return null;
    }

    public JsonObject parseJson(JsonObject var1, String var2);

    default public void copyOverSingleBlock(JsonObject ore, JsonObject oreOut) {
        JsonObject blockEntry = new JsonObject();
        block15: for (Map.Entry prop : ore.entrySet()) {
            switch ((String)prop.getKey()) {
                case "block": 
                case "blockID": {
                    blockEntry.addProperty("name", ((JsonElement)prop.getValue()).getAsString());
                    continue block15;
                }
                case "metaData": {
                    blockEntry.addProperty("metaData", ((JsonElement)prop.getValue()).getAsNumber());
                    continue block15;
                }
                case "state": {
                    blockEntry.addProperty("state", ((JsonElement)prop.getValue()).getAsString());
                    continue block15;
                }
                case "chance": {
                    blockEntry.addProperty("chance", ((JsonElement)prop.getValue()).getAsNumber());
                    continue block15;
                }
                case "replace_block": {
                    oreOut.addProperty("replaces", ((JsonElement)prop.getValue()).getAsString());
                    continue block15;
                }
            }
            if (oreOut.has((String)prop.getKey())) continue;
            oreOut.add((String)prop.getKey(), (JsonElement)prop.getValue());
        }
        if (!blockEntry.has("chance")) {
            blockEntry.addProperty("chance", (Number)100);
        }
        if (!oreOut.has("blocks")) {
            oreOut.add("blocks", (JsonElement)new JsonArray());
        }
        JsonArray temp = oreOut.getAsJsonArray("blocks");
        temp.add((JsonElement)blockEntry);
        oreOut.add("blocks", (JsonElement)temp);
    }

    default public void normalizeBlockData(JsonObject ore, JsonObject oreOut) {
        JsonObject blockEntry = new JsonObject();
        if (ore.has("state")) {
            blockEntry.addProperty("state", ore.get("state").getAsString());
        } else if (ore.has("metaData")) {
            blockEntry.addProperty("metaData", (Number)ore.get("metaData").getAsInt());
        }
        String blockName = ore.has("blockID") ? ore.get("blockID").getAsString() : (ore.has("block") ? ore.get("block").getAsString() : "i_am_a_dumbass");
        blockEntry.addProperty("name", blockName);
        oreOut.add("blocks", (JsonElement)blockEntry);
    }

    default public JsonArray getDimensionData(JsonObject retVal, int dimension) {
        if (!retVal.has("dimensions")) {
            retVal.add("dimensions", (JsonElement)new JsonObject());
        }
        if (!retVal.getAsJsonObject("dimensions").has(String.format("%d", dimension))) {
            retVal.getAsJsonObject("dimensions").add(String.format("%d", dimension), (JsonElement)new JsonArray());
        }
        return retVal.getAsJsonObject("dimensions").getAsJsonArray(String.format("%d", dimension));
    }

    default public JsonObject replaceVariables(JsonObject objReplace) {
        JsonObject retVal = new JsonObject();
        objReplace.entrySet().forEach(entry -> retVal.add((String)entry.getKey(), this.replaceVariablesBase((JsonElement)entry.getValue())));
        return retVal;
    }

    default public JsonElement replaceVariablesBase(JsonElement value) {
        if (value.isJsonPrimitive() && value.getAsString().startsWith("$.")) {
            return this.replaceVariablePrimitive(value);
        }
        if (value.isJsonPrimitive()) {
            return value;
        }
        if (value.isJsonArray()) {
            return this.replaceVariableArray(value);
        }
        if (value.isJsonObject()) {
            return this.replaceVariables(value.getAsJsonObject());
        }
        return value;
    }

    default public JsonElement replaceVariableArray(JsonElement value) {
        JsonArray retVal = new JsonArray();
        value.getAsJsonArray().forEach(item -> retVal.add(this.replaceVariablesBase((JsonElement)item)));
        return retVal;
    }

    default public JsonElement replaceVariablePrimitive(JsonElement value) {
        String rawVal = value.getAsString().substring(2);
        String[] bits = rawVal.split("\\.");
        String section = bits[0];
        String item = bits[1];
        return this.getStorage().getSymbolSection(section, item);
    }

    default public String getBlockName(JsonObject ore) {
        String key;
        if (ore.has("block")) {
            key = "block";
        } else if (ore.has("blockID")) {
            key = "blockID";
        } else {
            return String.format("ore-%d", new Random().nextInt());
        }
        return ore.get(key).getAsString();
    }

    default public String getBlockNameMulti(JsonObject ore) {
        LinkedList<String> rv = new LinkedList<String>();
        JsonArray ores = ore.get("blocks").getAsJsonArray();
        for (JsonElement o : ores) {
            rv.add(o.getAsJsonObject().get("name").getAsString());
        }
        return String.join((CharSequence)"-", rv.toArray(new String[0]));
    }
}

