/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json.os3.readers;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.api.os3.OreBuilder;
import com.mcmoddev.orespawn.api.os3.SpawnBuilder;
import com.mcmoddev.orespawn.impl.location.BiomeLocationComposition;
import com.mcmoddev.orespawn.impl.location.BiomeLocationDictionary;
import com.mcmoddev.orespawn.impl.location.BiomeLocationList;
import com.mcmoddev.orespawn.impl.location.BiomeLocationSingle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class Helpers {
    private Helpers() {
    }

    private static BiomeLocation deserializeSingleEntry(String in) {
        if (in.contains(":")) {
            String[] parts = in.split(":");
            return new BiomeLocationSingle((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(parts[0], parts[1])));
        }
        return new BiomeLocationDictionary(BiomeDictionary.Type.getType((String)in, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
    }

    private static BiomeLocation deserializeBiomeLocationList(JsonArray in) {
        ArrayList myData = new ArrayList();
        if (in.size() == 0) {
            return new BiomeLocationList((ImmutableSet<BiomeLocation>)ImmutableSet.copyOf(Collections.emptySet()));
        }
        in.forEach(elem -> {
            if (elem.isJsonPrimitive()) {
                myData.add(Helpers.deserializeSingleEntry(elem.getAsString()));
            } else if (elem.isJsonObject()) {
                myData.add(Helpers.deserializeBiomeLocationComposition(elem.getAsJsonObject()));
            }
        });
        return new BiomeLocationList((ImmutableSet<BiomeLocation>)ImmutableSet.copyOf(myData));
    }

    public static BiomeLocationComposition deserializeBiomeLocationComposition(JsonObject in) {
        JsonArray includeArr = in.getAsJsonArray("includes");
        JsonArray excludeArr = in.getAsJsonArray("excludes");
        if (includeArr == null) {
            includeArr = new JsonArray();
        }
        if (excludeArr == null) {
            excludeArr = new JsonArray();
        }
        BiomeLocation includes = null;
        BiomeLocation excludes = null;
        if (includeArr.size() > 0) {
            includes = Helpers.deserializeBiomeLocationList(includeArr);
        }
        if (excludeArr.size() > 0) {
            excludes = Helpers.deserializeBiomeLocationList(excludeArr);
        }
        return new BiomeLocationComposition((ImmutableSet<BiomeLocation>)(includes == null ? ImmutableSet.copyOf(Collections.emptySet()) : ImmutableSet.of((Object)includes)), (ImmutableSet<BiomeLocation>)(excludes == null ? ImmutableSet.copyOf(Collections.emptySet()) : ImmutableSet.of((Object)excludes)));
    }

    private static void handleState(JsonObject ore, OreBuilder oreB, String oreName) {
        if (ore.has("state")) {
            String stateString = ore.get("state").getAsString();
            if ("normal".equals(stateString)) {
                oreB.setOre(oreName);
            } else {
                oreB.setOre(oreName, stateString);
            }
        } else if (ore.has("metaData")) {
            oreB.setOre(oreName, ore.get("metaData").getAsInt());
        } else {
            oreB.setOre(oreName);
        }
    }

    private static OreBuilder parseOreEntry(JsonObject oreSpawn, SpawnBuilder spawn) {
        String blockName = oreSpawn.has("block") ? "block" : "name";
        String oreName = oreSpawn.get(blockName).getAsString();
        int chance = oreSpawn.has("chance") ? oreSpawn.get("chance").getAsInt() : 100;
        OreBuilder thisOre = spawn.newOreBuilder();
        Helpers.handleState(oreSpawn, thisOre, oreName);
        thisOre.setChance(chance);
        return thisOre;
    }

    private static List<OreBuilder> loadOreDict(JsonObject oreObj, SpawnBuilder spawn) {
        String oreName = oreObj.get("block").getAsString().split(":")[1];
        int chance = oreObj.has("chance") ? oreObj.get("chance").getAsInt() : 100;
        ArrayList<OreBuilder> retval = new ArrayList<OreBuilder>();
        NonNullList ores = OreDictionary.getOres((String)oreName);
        for (ItemStack ore : ores) {
            OreBuilder thisOre = spawn.newOreBuilder();
            thisOre.setOre(ore.func_77973_b(), ore.func_77960_j());
            thisOre.setChance(chance);
            retval.add(thisOre);
        }
        return retval;
    }

    public static List<OreBuilder> loadOres(JsonArray oresArray, SpawnBuilder spawn) {
        LinkedList<OreBuilder> rV = new LinkedList<OreBuilder>();
        oresArray.forEach(oreEntry -> {
            JsonObject work = oreEntry.getAsJsonObject();
            String oreName = work.get("name").getAsString();
            OreBuilder ores = spawn.newOreBuilder();
            if (work.has("state") || work.has("metaData")) {
                Helpers.handleState(work, ores, oreName);
                rV.add(ores);
            } else if (oreName.toLowerCase().startsWith("ore:")) {
                rV.addAll(Helpers.loadOreDict(work, spawn));
            } else {
                rV.add(Helpers.parseOreEntry(work, spawn));
            }
        });
        return rV;
    }
}

