/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json.os3.readers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.json.os3.IOS3Reader;

public final class OS3V1Reader
implements IOS3Reader {
    @Override
    public JsonObject parseJson(JsonObject entries, String fileName) {
        JsonArray elements = entries.get("dimensions").getAsJsonArray();
        JsonObject retVal = new JsonObject();
        for (JsonElement element : elements) {
            JsonObject object = element.getAsJsonObject();
            int dimension = object.has("dimension") ? object.get("dimension").getAsInt() : OreSpawn.API.dimensionWildcard();
            JsonArray dimData = this.getDimensionData(retVal, dimension);
            JsonArray ores = object.get("ores").getAsJsonArray();
            for (JsonElement oresEntry : ores) {
                JsonObject ore = oresEntry.getAsJsonObject();
                ore.addProperty("retrogen", Boolean.valueOf(true));
                ore.addProperty("enabled", Boolean.valueOf(true));
                JsonObject oreOut = this.handleVersionDifferences(ore, entries.get("version").getAsString());
                dimData.add((JsonElement)oreOut);
            }
            retVal.getAsJsonObject("dimensions").add(Integer.toString(dimension), (JsonElement)dimData);
        }
        return retVal;
    }

    private JsonObject handleVersionDifferences(JsonObject ore, String version) {
        JsonObject returnValue = new JsonObject();
        if ("1".equals(version) || "1.1".equals(version)) {
            this.copyOverSingleBlock(ore, returnValue);
        }
        switch (version) {
            case "1.2": {
                ore.entrySet().forEach(prop -> returnValue.add((String)prop.getKey(), (JsonElement)prop.getValue()));
                break;
            }
            case "1.1": {
                JsonArray biomes = ore.has("biomes") ? ore.getAsJsonArray("biomes") : new JsonArray();
                JsonObject biomeObj = new JsonObject();
                biomeObj.add(biomes.size() < 1 ? "excludes" : "includes", (JsonElement)biomes);
                returnValue.add("biomes", (JsonElement)biomeObj);
                returnValue.add("biomes", (JsonElement)new JsonObject());
                returnValue.addProperty("name", this.getBlockName(ore));
                break;
            }
            case "1": {
                returnValue.add("biomes", (JsonElement)new JsonObject());
                returnValue.addProperty("name", this.getBlockName(ore));
                break;
            }
        }
        return returnValue;
    }
}

