/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json.os3.readers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.json.os3.IOS3Reader;
import com.mcmoddev.orespawn.util.OS3V2PresetStorage;
import java.util.Map;

public class OS3V2Reader
implements IOS3Reader {
    private OS3V2PresetStorage storage = new OS3V2PresetStorage();

    @Override
    public OS3V2PresetStorage getStorage() {
        return this.storage;
    }

    @Override
    public JsonObject parseJson(JsonObject entries, String fileName) {
        JsonObject spawns = entries.getAsJsonObject("spawns");
        JsonObject retVal = new JsonObject();
        this.storage.clear();
        OreSpawn.API.getPresets().copy(this.storage);
        this.loadLocalPresets(entries);
        JsonObject work = new JsonObject();
        spawns.entrySet().forEach(entry -> work.add((String)entry.getKey(), (JsonElement)this.replaceVariables(((JsonElement)entry.getValue()).getAsJsonObject())));
        work.entrySet().forEach(entry -> {
            JsonObject lw = this.setHandleDimensions(((JsonElement)entry.getValue()).getAsJsonObject());
            lw.getAsJsonArray("dimensions").getAsJsonArray().forEach(dim -> {
                JsonObject nw = new JsonObject();
                nw.addProperty("name", (String)entry.getKey());
                if (lw.has("dimension")) {
                    nw.add("dimension", (JsonElement)lw.getAsJsonObject("dimension"));
                }
                ((JsonElement)entry.getValue()).getAsJsonObject().entrySet().stream().filter(e -> !((String)e.getKey()).equals("dimensions")).forEach(ent -> nw.add((String)ent.getKey(), (JsonElement)ent.getValue()));
                JsonArray thisDim = this.getDimensionData(retVal, dim.getAsInt());
                thisDim.add((JsonElement)nw);
                JsonObject dimStore = retVal.has("dimensions") ? retVal.getAsJsonObject("dimensions") : new JsonObject();
                dimStore.add(dim.getAsString(), (JsonElement)thisDim);
                retVal.add("dimensions", (JsonElement)dimStore);
            });
        });
        return retVal;
    }

    private JsonObject setHandleDimensions(JsonObject spawnEntry) {
        JsonObject lw = spawnEntry;
        if (lw.get("dimensions").isJsonArray()) {
            if (lw.getAsJsonArray("dimensions").size() < 1) {
                JsonArray temp = lw.getAsJsonArray("dimensions");
                temp.add((Number)OreSpawn.API.dimensionWildcard());
                lw.remove("dimensions");
                lw.add("dimensions", (JsonElement)temp);
            }
        } else {
            JsonObject dimSet = lw.getAsJsonObject("dimensions");
            lw.add("dimension", (JsonElement)dimSet);
            lw.remove("dimensions");
            JsonArray temp = new JsonArray();
            temp.add((Number)OreSpawn.API.dimensionWildcard());
            lw.add("dimensions", (JsonElement)temp);
        }
        return lw;
    }

    private void loadLocalPresets(JsonObject entries) {
        boolean hasPresets = entries.has("presets");
        if (hasPresets) {
            for (Map.Entry preset : entries.get("presets").getAsJsonObject().entrySet()) {
                String sectionName = (String)preset.getKey();
                JsonObject entry = ((JsonElement)preset.getValue()).getAsJsonObject();
                for (Map.Entry variables : entry.entrySet()) {
                    String itemName = (String)variables.getKey();
                    JsonElement varValue = (JsonElement)variables.getValue();
                    this.storage.setSymbolSection(sectionName, itemName, varValue);
                }
            }
        }
    }
}

