/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class OS3V2PresetStorage {
    private final Map<String, Map<String, JsonElement>> storage = new TreeMap<String, Map<String, JsonElement>>();

    public void setSymbolSection(String sectionName, String itemName, JsonElement value) {
        Map temp = this.storage.getOrDefault(sectionName, new HashMap());
        temp.put(itemName, value);
        this.storage.put(sectionName, temp);
    }

    public JsonElement getSymbolSection(String sectionName, String itemName) {
        if (this.storage.containsKey(sectionName) && this.storage.get(sectionName).containsKey(itemName)) {
            return this.storage.get(sectionName).get(itemName);
        }
        return new JsonPrimitive(itemName);
    }

    public void copy(OS3V2PresetStorage dest) {
        this.storage.entrySet().stream().forEach(ensm -> {
            String section = (String)ensm.getKey();
            ((Map)ensm.getValue()).entrySet().forEach(ensje -> dest.setSymbolSection(section, (String)ensje.getKey(), (JsonElement)ensje.getValue()));
        });
    }

    public void clear() {
        this.storage.clear();
    }
}

