/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.util;

import com.google.common.collect.ImmutableList;
import com.mcmoddev.orespawn.api.os3.OreBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;

public class OreList {
    private List<Integer> myChanceList = new LinkedList<Integer>();
    private List<OreBuilder> myCopy = new LinkedList<OreBuilder>();
    private Integer listCount = 0;

    public void build(List<OreBuilder> ores) {
        ores.stream().sorted(Comparator.comparingInt(OreBuilder::getChance)).forEach(ob -> {
            this.myChanceList.add(ob.getChance());
            this.myCopy.add((OreBuilder)ob);
        });
        this.listCount = this.myChanceList.stream().mapToInt(Integer::intValue).max().getAsInt();
    }

    public OreBuilder getRandomOre(Random rand) {
        int v = rand.nextInt(this.listCount);
        int c = 0;
        for (Integer i : this.myChanceList) {
            if ((c += i.intValue()) <= v) continue;
            OreBuilder rv = this.getOreWithChance(i);
            if (rv == null) break;
            return rv;
        }
        return this.getMaxChanceOre();
    }

    private OreBuilder getMaxChanceOre() {
        return this.getOreWithChance(this.myChanceList.stream().mapToInt(Integer::intValue).max().getAsInt());
    }

    private OreBuilder getOreWithChance(int intValue) {
        for (OreBuilder o : this.myCopy) {
            if (o.getChance() != intValue) continue;
            return o;
        }
        return null;
    }

    public ImmutableList<IBlockState> getOres() {
        return ImmutableList.copyOf((Collection)this.myCopy.stream().map(OreBuilder::getOre).distinct().collect(Collectors.toList()));
    }
}

