/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.worldgen;

import com.google.common.collect.ImmutableList;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.GeneratorParameters;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.os3.SpawnBuilder;
import com.mcmoddev.orespawn.data.Config;
import com.mcmoddev.orespawn.data.ReplacementsRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.oredict.OreDictionary;

public class OreSpawnWorldGen
implements IWorldGenerator {
    private final Map<Integer, List<SpawnBuilder>> dimensions;
    private static final List<Block> SPAWN_BLOCKS = new ArrayList<Block>();

    public OreSpawnWorldGen(Map<Integer, List<SpawnBuilder>> allDimensions, long nextLong) {
        this.dimensions = Collections.unmodifiableMap(allDimensions);
        if (SPAWN_BLOCKS.isEmpty()) {
            SPAWN_BLOCKS.add(Blocks.field_150348_b);
            SPAWN_BLOCKS.add(Blocks.field_150424_aL);
            SPAWN_BLOCKS.add(Blocks.field_150377_bs);
            SPAWN_BLOCKS.addAll(OreDictionary.getOres((String)"stone").stream().filter(stack -> stack.func_77973_b() instanceof ItemBlock).map(stack -> ((ItemBlock)stack.func_77973_b()).func_179223_d()).collect(Collectors.toList()));
        }
    }

    public static ImmutableList<Block> getSpawnBlocks() {
        return ImmutableList.copyOf(SPAWN_BLOCKS);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int thisDim = world.field_73011_w.getDimension();
        ArrayList entries = new ArrayList(this.dimensions.getOrDefault(thisDim, new ArrayList()));
        if (!((List)this.dimensions.getOrDefault(OreSpawn.API.dimensionWildcard(), new ArrayList())).isEmpty()) {
            entries.addAll(this.dimensions.get(OreSpawn.API.dimensionWildcard()).stream().filter(ent -> !ent.hasExtendedDimensions() && thisDim > 0 && thisDim != 1 || ent.extendedDimensionsMatch(thisDim)).collect(Collectors.toList()));
        }
        entries.stream().filter(SpawnBuilder::enabled).filter(sb -> !Config.getBoolean("Retrogen") || sb.retrogen() || Config.getBoolean("Force Retrogen")).forEach(sE -> {
            IFeature currentFeatureGen = sE.getFeatureGen().getGenerator();
            ImmutableList<IBlockState> replacement = sE.getReplacementBlocks();
            replacement = replacement.isEmpty() ? ReplacementsRegistry.getDimensionDefault(thisDim) : replacement;
            GeneratorParameters parameters = new GeneratorParameters(new ChunkPos(chunkX, chunkZ), sE.getOreSpawns(), (List<IBlockState>)replacement, sE.getBiomes(), sE.getFeatureGen().getParameters());
            currentFeatureGen.setRandom(random);
            currentFeatureGen.generate(world, chunkGenerator, chunkProvider, parameters);
        });
    }
}

