/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="projectex")
@Config(modid="projectex", category="")
public class ProjectEXConfig {
    @Config.LangKey(value="stat.generalButton")
    public static final General general = new General();
    @Config.RequiresMcRestart
    public static final ItemsConfig items = new ItemsConfig();
    public static final Tiers tiers = new Tiers();

    public static void sync() {
        ConfigManager.sync((String)"projectex", (Config.Type)Config.Type.INSTANCE);
        general.stoneTableItemList = null;
        general.stoneTableCache = null;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("projectex")) {
            ProjectEXConfig.sync();
        }
    }

    public static class ItemsConfig {
        @Config.LangKey(value="tile.projectex.personal_link.name")
        public boolean link = true;
        @Config.LangKey(value="item.projectex.knowledge_sharing_book.name")
        public boolean knowledge_sharing_book = true;
        public boolean stars = true;
        @Config.LangKey(value="item.projectex.final_star.name")
        public boolean final_star = true;
        public boolean collectors = true;
        public boolean relays = true;
        public boolean power_flowers = true;
        public boolean tome = true;
        @Config.LangKey(value="tile.projectex.stone_table.name")
        public boolean stone_table = true;
        @Config.LangKey(value="item.projectex.arcane_tablet.name")
        public boolean arcane_tablet = true;
        @Config.LangKey(value="item.projectex.matter.clay.name")
        public boolean clay_matter = false;
        @Config.LangKey(value="tile.projectex.alchemy_table.name")
        public boolean alchemy_table = true;
    }

    public static class BlockTier {
        @Config.LangKey(value="projectex.tiers.collector_output")
        public double collector_output;
        @Config.LangKey(value="projectex.tiers.relay_bonus")
        public double relay_bonus;
        @Config.LangKey(value="projectex.tiers.relay_transfer")
        public double relay_transfer;

        public BlockTier(double co, double rb, double rt) {
            this.collector_output = co;
            this.relay_bonus = rb;
            this.relay_transfer = rt;
        }

        public double powerFlowerOutput() {
            return this.collector_output * 18.0 + this.relay_bonus * 30.0;
        }
    }

    public static class Tiers {
        public final BlockTier basic = new BlockTier(4.0, 1.0, 64.0);
        public final BlockTier dark = new BlockTier(12.0, 3.0, 192.0);
        public final BlockTier red = new BlockTier(40.0, 10.0, 640.0);
        public final BlockTier magenta = new BlockTier(160.0, 40.0, 2560.0);
        public final BlockTier pink = new BlockTier(640.0, 150.0, 10240.0);
        public final BlockTier purple = new BlockTier(2560.0, 750.0, 40960.0);
        public final BlockTier violet = new BlockTier(10240.0, 3750.0, 163840.0);
        public final BlockTier blue = new BlockTier(40960.0, 15000.0, 655360.0);
        public final BlockTier cyan = new BlockTier(163840.0, 60000.0, 2621440.0);
        public final BlockTier green = new BlockTier(655360.0, 240000.0, 1.048576E7);
        public final BlockTier lime = new BlockTier(2621440.0, 960000.0, 4.194304E7);
        public final BlockTier yellow = new BlockTier(1.048576E7, 3840000.0, 1.6777216E8);
        public final BlockTier orange = new BlockTier(4.194304E7, 1.536E7, 6.7108864E8);
        public final BlockTier white = new BlockTier(1.6777216E8, 6.144E7, 2.68435456E9);
        public final BlockTier fading = new BlockTier(6.7108864E8, 2.4576E8, 1.073741824E10);
        public final BlockTier final_tier = new BlockTier(1.0E12, 1.0E12, Double.MAX_VALUE);
    }

    public static class General {
        @Config.Comment(value={"Overrides default EMC formatter from ProjectE with custom one."})
        public boolean override_emc_formatter = true;
        @Config.Comment(value={"With this enabled, Power Flowers will not be affected by Watch of Flowing Time."})
        public boolean blacklist_power_flower_from_watch = true;
        @Config.Comment(value={"If set to false, it will only copy items with EMC value."})
        public boolean final_star_copy_any_item = true;
        @Config.Comment(value={"If set to false, it will remove item NBT."})
        public boolean final_star_copy_nbt = false;
        @Config.Comment(value={"Set to 0 to completely disable itemc copying."})
        @Config.RangeInt(min=0)
        public int final_star_update_interval = 20;
        @Config.Comment(value={"Max item that will be displayed.", "0 disables item exporting from links and makes refined ones useless.", "Reduce this if you are having problems with auto-crafting or similar things."})
        public int emc_link_max_out = 2000000000;
        @Config.Comment(value={"The whitelist for Stone Table will be ignored unless this is set to true."})
        public boolean enable_stone_table_whitelist = false;
        public String[] stone_table_whitelist = new String[]{"oredict:ingot", "oredict:gem", "oredict:dust", "oredict:nugget", "oredict:block", "oredict:ore", "oredict:stone", "oredict:cobblestone", "oredict:sand", "oredict:dirt", "oredict:gravel", "oredict:obsidian", "oredict:netherrack", "oredict:endstone", "minecraft:coal@*", "minecraft:flint", "minecraft:clay_ball", "oredict:dye", "oredict:string", "oredict:leather", "oredict:sugercane", "oredict:feather", "oredict:gunpowder", "minecraft:wheat_seeds", "oredict:logWood", "oredict:treeSapling", "oredict:blockGlassColorless", "oredict:enderpearl", "minecraft:blaze_rod", "minecraft:ghast_tear"};
        private HashSet<ItemKey> stoneTableItemList = null;
        private HashMap<ItemKey, Boolean> stoneTableCache = null;

        public boolean isStoneTableWhitelisted(ItemStack stack) {
            if (!this.enable_stone_table_whitelist) {
                return true;
            }
            if (this.stoneTableItemList == null) {
                this.stoneTableItemList = new HashSet();
                HashMap oreDict = new HashMap();
                for (String s : OreDictionary.getOreNames()) {
                    HashSet<ItemKey> set = new HashSet<ItemKey>();
                    for (Object stack1 : OreDictionary.getOres((String)s)) {
                        Item item = stack1.func_77973_b();
                        ItemKey key = new ItemKey();
                        key.item = item;
                        key.metadata = stack1.func_77960_j();
                        set.add(key);
                    }
                    oreDict.put(s, set);
                }
                for (String s : ProjectEXConfig.general.stone_table_whitelist) {
                    String[] s1 = s.trim().split("@", 2);
                    if (s1[0].isEmpty()) continue;
                    if (s1.length == 1 && s1[0].startsWith("oredict:")) {
                        String s2 = s1[0].substring(8);
                        if (s2.isEmpty()) continue;
                        for (Map.Entry entry : oreDict.entrySet()) {
                            if (((HashSet)entry.getValue()).isEmpty() || !((String)entry.getKey()).startsWith(s2)) continue;
                            this.stoneTableItemList.addAll((Collection)entry.getValue());
                        }
                        continue;
                    }
                    Item item = Item.func_111206_d((String)s1[0]);
                    if (item == null || item == Items.field_190931_a) continue;
                    ItemKey key = new ItemKey();
                    key.item = item;
                    key.metadata = s1.length == 1 ? 0 : (s1[1].equals("*") ? Short.MAX_VALUE : Integer.parseInt(s1[1]));
                    this.stoneTableItemList.add(key);
                }
            }
            if (this.stoneTableCache == null) {
                this.stoneTableCache = new HashMap();
            }
            ItemKey key = new ItemKey();
            key.item = stack.func_77973_b();
            key.metadata = stack.func_77960_j();
            Boolean b = this.stoneTableCache.get(key);
            if (b == null) {
                b = false;
                for (ItemKey key1 : this.stoneTableItemList) {
                    if (key.item != key1.item || key.metadata != key1.metadata && key1.metadata != Short.MAX_VALUE) continue;
                    b = true;
                    break;
                }
                this.stoneTableCache.put(key, b);
            }
            return b;
        }
    }

    private static class ItemKey {
        private Item item;
        private int metadata;

        private ItemKey() {
        }

        public int hashCode() {
            return this.item.hashCode() * 31 + this.metadata;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemKey) {
                ItemKey key = (ItemKey)obj;
                return this.item == key.item && this.metadata == key.metadata;
            }
            return false;
        }

        public String toString() {
            return this.item.getRegistryName() + "@" + this.metadata;
        }
    }
}

