/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex.client;

import com.latmod.mods.projectex.ProjectEXConfig;
import com.latmod.mods.projectex.block.EnumMatter;
import com.latmod.mods.projectex.block.EnumTier;
import com.latmod.mods.projectex.client.EnumScreenPosition;
import com.latmod.mods.projectex.client.ProjectEXClientConfig;
import com.latmod.mods.projectex.gui.EMCFormat;
import com.latmod.mods.projectex.integration.PersonalEMC;
import com.latmod.mods.projectex.item.ProjectEXItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="projectex", value={Side.CLIENT})
public class ProjectEXClientEventHandler {
    private static double lastEMC;
    private static long lastUpdate;
    private static double[] emcsa;
    public static double emcs;

    private static void addModel(Item item, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        if (ProjectEXConfig.items.link) {
            ProjectEXClientEventHandler.addModel(ProjectEXItems.ENERGY_LINK, "normal");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.PERSONAL_LINK, "normal");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.REFINED_LINK, "normal");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.COMPRESSED_REFINED_LINK, "normal");
        }
        for (EnumTier enumTier : EnumTier.VALUES) {
            if (ProjectEXConfig.items.collectors) {
                ModelLoader.setCustomModelResourceLocation((Item)ProjectEXItems.COLLECTOR, (int)enumTier.ordinal(), (ModelResourceLocation)new ModelResourceLocation(ProjectEXItems.COLLECTOR.getRegistryName(), "tier=" + enumTier.func_176610_l()));
            }
            if (ProjectEXConfig.items.relays) {
                ModelLoader.setCustomModelResourceLocation((Item)ProjectEXItems.RELAY, (int)enumTier.ordinal(), (ModelResourceLocation)new ModelResourceLocation(ProjectEXItems.RELAY.getRegistryName(), "tier=" + enumTier.func_176610_l()));
            }
            if (!ProjectEXConfig.items.power_flowers) continue;
            ModelLoader.setCustomModelResourceLocation((Item)ProjectEXItems.COMPRESSED_COLLECTOR, (int)enumTier.ordinal(), (ModelResourceLocation)new ModelResourceLocation(ProjectEXItems.COLLECTOR.getRegistryName(), "tier=" + enumTier.func_176610_l()));
            ModelLoader.setCustomModelResourceLocation((Item)ProjectEXItems.POWER_FLOWER, (int)enumTier.ordinal(), (ModelResourceLocation)new ModelResourceLocation(ProjectEXItems.POWER_FLOWER.getRegistryName(), "tier=" + enumTier.func_176610_l()));
        }
        if (ProjectEXConfig.items.stone_table) {
            ProjectEXClientEventHandler.addModel(ProjectEXItems.STONE_TABLE, "facing=down");
        }
        if (ProjectEXConfig.items.alchemy_table) {
            ProjectEXClientEventHandler.addModel(ProjectEXItems.ALCHEMY_TABLE, "normal");
        }
        if (ProjectEXConfig.items.stars) {
            ProjectEXClientEventHandler.addModel(ProjectEXItems.MAGNUM_STAR_EIN, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.MAGNUM_STAR_ZWEI, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.MAGNUM_STAR_DREI, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.MAGNUM_STAR_VIER, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.MAGNUM_STAR_SPHERE, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.MAGNUM_STAR_OMEGA, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.COLOSSAL_STAR_EIN, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.COLOSSAL_STAR_ZWEI, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.COLOSSAL_STAR_DREI, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.COLOSSAL_STAR_VIER, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.COLOSSAL_STAR_SPHERE, "inventory");
            ProjectEXClientEventHandler.addModel(ProjectEXItems.COLOSSAL_STAR_OMEGA, "inventory");
        }
        for (Enum enum_ : EnumMatter.VALUES) {
            ModelLoader.setCustomModelResourceLocation((Item)ProjectEXItems.MATTER, (int)enum_.ordinal(), (ModelResourceLocation)new ModelResourceLocation("projectex:matter/" + ((EnumMatter)enum_).func_176610_l() + "#inventory"));
        }
        if (ProjectEXConfig.items.clay_matter) {
            ModelLoader.setCustomModelResourceLocation((Item)ProjectEXItems.CLAY_MATTER, (int)0, (ModelResourceLocation)new ModelResourceLocation("projectex:matter/clay#inventory"));
        }
        ProjectEXClientEventHandler.addModel(ProjectEXItems.FINAL_STAR_SHARD, "inventory");
        if (ProjectEXConfig.items.final_star) {
            ProjectEXClientEventHandler.addModel(ProjectEXItems.FINAL_STAR, "inventory");
        }
        if (ProjectEXConfig.items.knowledge_sharing_book) {
            ProjectEXClientEventHandler.addModel(ProjectEXItems.KNOWLEDGE_SHARING_BOOK, "inventory");
        }
        if (ProjectEXConfig.items.arcane_tablet) {
            ProjectEXClientEventHandler.addModel(ProjectEXItems.ARCANE_TABLET, "inventory");
        }
    }

    @SubscribeEvent
    public static void addInfoText(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            long now = System.currentTimeMillis();
            double emc = PersonalEMC.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getEmc();
            if (now - lastUpdate >= 1000L) {
                System.arraycopy(emcsa, 1, emcsa, 0, emcsa.length - 1);
                ProjectEXClientEventHandler.emcsa[ProjectEXClientEventHandler.emcsa.length - 1] = emc - lastEMC;
                lastEMC = emc;
                lastUpdate = now;
                emcs = 0.0;
                for (double d : emcsa) {
                    emcs += d;
                }
                emcs /= (double)emcsa.length;
            }
            if (ProjectEXClientConfig.general.emc_screen_position != EnumScreenPosition.DISABLED && emc > 0.0) {
                String s = EMCFormat.INSTANCE.format(emc);
                if (emcs != 0.0) {
                    s = s + (emcs > 0.0 ? TextFormatting.GREEN + "+" : TextFormatting.RED + "-") + EMCFormat.INSTANCE.format(Math.abs(emcs)) + "/s";
                }
                (ProjectEXClientConfig.general.emc_screen_position == EnumScreenPosition.TOP_LEFT ? event.getLeft() : event.getRight()).add("EMC: " + s);
            }
        }
    }

    static {
        emcsa = new double[5];
        emcs = 0.0;
    }
}

