/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex.integration;

import com.latmod.mods.projectex.ProjectEX;
import com.latmod.mods.projectex.integration.OfflineKnowledgeProvider;
import com.latmod.mods.projectex.net.MessageSyncEMC;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.impl.KnowledgeImpl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="projectex")
public class PersonalEMC {
    private static final HashSet<UUID> LOGGED_IN_PLAYERS = new HashSet();
    private static final Map<UUID, OfflineKnowledgeProvider> OFFLINE_MAP = new HashMap<UUID, OfflineKnowledgeProvider>();
    private static final Map<UUID, Double> EMC_MAP = new HashMap<UUID, Double>();

    @Nullable
    public static IKnowledgeProvider get(@Nullable World world, @Nullable UUID id) {
        if (world == null || id == null || id.getLeastSignificantBits() == 0L && id.getMostSignificantBits() == 0L) {
            return null;
        }
        if (world.field_72995_K) {
            EntityPlayer player = ProjectEX.PROXY.getClientPlayer();
            return player == null ? null : PersonalEMC.get(player);
        }
        EntityPlayerMP player = world.func_73046_m().func_184103_al().func_177451_a(id);
        if (player != null) {
            return PersonalEMC.get((EntityPlayer)player);
        }
        OfflineKnowledgeProvider provider = OFFLINE_MAP.get(id);
        if (provider == null) {
            File playerFile;
            provider = new OfflineKnowledgeProvider(id);
            OFFLINE_MAP.put(provider.playerId, provider);
            File playerDataFolder = new File(world.func_72860_G().func_75765_b(), "playerdata");
            if (playerDataFolder.exists() && (playerFile = new File(playerDataFolder, provider.playerId + ".dat")).exists() && playerFile.isFile()) {
                try (FileInputStream in = new FileInputStream(playerFile);){
                    NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)in).func_74775_l("ForgeCaps").func_74775_l(KnowledgeImpl.Provider.NAME.toString());
                    if (!nbt.func_82582_d()) {
                        provider.deserializeNBT(nbt);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        return provider;
    }

    public static IKnowledgeProvider get(EntityPlayer player) {
        return (IKnowledgeProvider)Objects.requireNonNull(player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null));
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        OfflineKnowledgeProvider knowledgeProvider;
        if (event.player instanceof EntityPlayerMP && LOGGED_IN_PLAYERS.add(event.player.func_110124_au()) && (knowledgeProvider = OFFLINE_MAP.get(event.player.func_110124_au())) != null) {
            IKnowledgeProvider provider = PersonalEMC.get(event.player);
            OfflineKnowledgeProvider.copy(knowledgeProvider, provider);
            OFFLINE_MAP.remove(knowledgeProvider.playerId);
            provider.sync((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP && LOGGED_IN_PLAYERS.remove(event.player.func_110124_au())) {
            IKnowledgeProvider provider = PersonalEMC.get(event.player);
            OfflineKnowledgeProvider knowledgeProvider = new OfflineKnowledgeProvider(event.player.func_110124_au());
            OfflineKnowledgeProvider.copy(provider, knowledgeProvider);
            OFFLINE_MAP.put(knowledgeProvider.playerId, knowledgeProvider);
            EMC_MAP.remove(knowledgeProvider.playerId);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            Double prev = EMC_MAP.get(event.player.func_110124_au());
            double emc = PersonalEMC.get(event.player).getEmc();
            if (prev == null || prev != emc) {
                EMC_MAP.put(event.player.func_110124_au(), emc);
                MessageSyncEMC.sync(event.player, emc);
            }
        }
    }

    @SubscribeEvent
    public static void worldSaved(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            for (OfflineKnowledgeProvider provider : OFFLINE_MAP.values()) {
                if (!provider.shouldSave) continue;
                provider.shouldSave = false;
                NBTTagCompound nbt = provider.serializeNBT();
                UUID id = provider.playerId;
                ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
                    File playerFile;
                    File playerDataFolder = new File(event.getWorld().func_72860_G().func_75765_b(), "playerdata");
                    if (playerDataFolder.exists() && (playerFile = new File(playerDataFolder, id + ".dat")).exists() && playerFile.isFile()) {
                        FileInputStream in = null;
                        NBTTagCompound playerData = null;
                        try {
                            in = new FileInputStream(playerFile);
                            playerData = CompressedStreamTools.func_74796_a((InputStream)in);
                            NBTTagCompound forgeCapsTag = playerData.func_74775_l("ForgeCaps");
                            forgeCapsTag.func_74782_a(KnowledgeImpl.Provider.NAME.toString(), (NBTBase)nbt);
                            playerData.func_74782_a("ForgeCaps", (NBTBase)forgeCapsTag);
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        if (playerData != null) {
                            FileOutputStream out = null;
                            try {
                                out = new FileOutputStream(playerFile);
                                CompressedStreamTools.func_74799_a((NBTTagCompound)playerData, (OutputStream)out);
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace();
                            }
                            IOUtils.closeQuietly((OutputStream)out);
                        }
                    }
                    return false;
                });
            }
        }
    }

    @SubscribeEvent
    public static void worldUnloaded(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            LOGGED_IN_PLAYERS.clear();
            OFFLINE_MAP.clear();
            EMC_MAP.clear();
        }
    }
}

