/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.BlockMultipart$;
import codechicken.multipart.TMultiPart;
import mrtjp.core.block.MTBlockTile;
import mrtjp.core.block.TTileOrient;
import mrtjp.core.inventory.InvWrapper;
import mrtjp.core.inventory.InvWrapper$;
import mrtjp.core.item.ItemKeyStack;
import mrtjp.core.world.WorldLib$;
import mrtjp.projectred.expansion.ItemStorage;
import mrtjp.projectred.expansion.TActiveDevice;
import mrtjp.projectred.transportation.PressurePayload;
import mrtjp.projectred.transportation.TPressureTube;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import scala.runtime.BoxedUnit;

public abstract class TActiveDevice$class {
    public static void save(TActiveDevice $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$save(tag);
        tag.func_74757_a("pow", $this.powered());
        tag.func_74757_a("act", $this.active());
        $this.itemStorage().save(tag);
    }

    public static void load(TActiveDevice $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$load(tag);
        $this.powered_$eq(tag.func_74767_n("pow"));
        $this.active_$eq(tag.func_74767_n("act"));
        $this.itemStorage().load(tag);
    }

    public static void writeDesc(TActiveDevice $this, MCDataOutput out) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$writeDesc(out);
        out.writeBoolean($this.powered()).writeBoolean($this.active());
    }

    public static void readDesc(TActiveDevice $this, MCDataInput in) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$readDesc(in);
        $this.powered_$eq(in.readBoolean());
        $this.active_$eq(in.readBoolean());
    }

    public static void read(TActiveDevice $this, MCDataInput in, int key) {
        int n = key;
        switch (n) {
            default: {
                $this.mrtjp$projectred$expansion$TActiveDevice$$super$read(in, key);
                break;
            }
            case 4: {
                $this.powered_$eq(in.readBoolean());
                $this.active_$eq(in.readBoolean());
                ((MTBlockTile)$this).markRender();
            }
        }
    }

    public static void sendStateUpdate(TActiveDevice $this) {
        ((MTBlockTile)$this).writeStream(4).writeBoolean($this.powered()).writeBoolean($this.active()).sendToChunk((TileEntity)$this);
    }

    public static boolean shouldAcceptBacklog(TActiveDevice $this) {
        return true;
    }

    public static boolean shouldAcceptInput(TActiveDevice $this) {
        return !$this.powered() && $this.itemStorage().isEmpty();
    }

    public static void onScheduledTick(TActiveDevice $this) {
        if (!((TileEntity)$this).func_145831_w().field_72995_K) {
            if ($this.itemStorage().isEmpty()) {
                if (!$this.powered()) {
                    $this.active_$eq(false);
                    $this.onDeactivate();
                    $this.sendStateUpdate();
                }
            } else {
                $this.exportBuffer();
                ((MTBlockTile)$this).scheduleTick($this.itemStorage().isEmpty() ? 4 : 16);
            }
        }
    }

    public static void onNeighborBlockChange(TActiveDevice $this) {
        if (((TileEntity)$this).func_145831_w().func_175640_z(((TileEntity)$this).func_174877_v())) {
            if ($this.powered()) {
                return;
            }
            $this.powered_$eq(true);
            ((MTBlockTile)$this).func_70296_d();
            if ($this.active()) {
                return;
            }
            $this.active_$eq(true);
            $this.onActivate();
            $this.sendStateUpdate();
        } else {
            if ($this.active() && !((MTBlockTile)$this).isTickScheduled()) {
                ((MTBlockTile)$this).scheduleTick(4);
            }
            $this.powered_$eq(false);
            ((MTBlockTile)$this).func_70296_d();
        }
    }

    public static void onDeactivate(TActiveDevice $this) {
    }

    public static void exportBuffer(TActiveDevice $this) {
        do {
            PressurePayload pressurePayload;
            if ($this.itemStorage().isEmpty()) {
                return;
            }
            PressurePayload r = $this.itemStorage().peek();
            if ($this.exportPipe(r) || $this.exportInv(r) || $this.exportEject(r)) {
                pressurePayload = $this.itemStorage().poll();
                continue;
            }
            $this.itemStorage().backlogged_$eq(true);
            pressurePayload = BoxedUnit.UNIT;
        } while (!$this.itemStorage().backlogged());
    }

    public static boolean exportPipe(TActiveDevice $this, PressurePayload r) {
        boolean bl;
        TPressureTube tPressureTube;
        TMultiPart tMultiPart = BlockMultipart$.MODULE$.getPart((IBlockAccess)((TileEntity)$this).func_145831_w(), ((TileEntity)$this).func_174877_v().func_177972_a(EnumFacing.field_82609_l[((TTileOrient)$this).side()]), 6);
        if (tMultiPart instanceof TPressureTube && (tPressureTube = (TPressureTube)tMultiPart).hasDestination(r, ((TTileOrient)$this).side() ^ 1)) {
            tPressureTube.injectPayload(r, ((TTileOrient)$this).side());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean exportInv(TActiveDevice $this, PressurePayload r) {
        boolean bl;
        InvWrapper w = InvWrapper$.MODULE$.wrap(((TileEntity)$this).func_145831_w(), ((TileEntity)$this).func_174877_v().func_177972_a(EnumFacing.field_82609_l[((TTileOrient)$this).side()]), EnumFacing.field_82609_l[((TTileOrient)$this).side() ^ 1]);
        if (w == null) {
            bl = false;
        } else {
            ItemKeyStack itemKeyStack = r.payload();
            itemKeyStack.stackSize_$eq(itemKeyStack.stackSize() - w.injectItem(r.payload().key(), r.payload().stackSize()));
            bl = r.payload().stackSize() <= 0;
        }
        return bl;
    }

    public static boolean exportEject(TActiveDevice $this, PressurePayload r) {
        BlockPos pos = ((TileEntity)$this).func_174877_v().func_177972_a(EnumFacing.field_82609_l[((TTileOrient)$this).side()]);
        if (((TileEntity)$this).func_145831_w().func_175667_e(pos) && !((TileEntity)$this).func_145831_w().func_175623_d(pos)) {
            return false;
        }
        WorldLib$.MODULE$.centerEject(((TileEntity)$this).func_145831_w(), ((TileEntity)$this).func_174877_v(), r.payload().makeStack(), ((TTileOrient)$this).side(), 0.25);
        return true;
    }

    public static void onBlockRemoval(TActiveDevice $this) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$onBlockRemoval();
        while (!$this.itemStorage().isEmpty()) {
            WorldLib$.MODULE$.dropItem(((TileEntity)$this).func_145831_w(), ((TileEntity)$this).func_174877_v(), $this.itemStorage().poll().payload().makeStack());
        }
        return;
    }

    public static void $init$(TActiveDevice $this) {
        $this.mrtjp$projectred$expansion$TActiveDevice$_setter_$itemStorage_$eq(new ItemStorage());
        $this.powered_$eq(false);
        $this.active_$eq(false);
    }
}

