/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.feature;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import vazkii.arl.util.RecipeHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.decoration.block.BlockColoredBed;
import vazkii.quark.decoration.item.ItemColoredBed;

public class ColoredBeds
extends Feature {
    public static Block[] colored_bed_blocks;
    public static Item colored_bed_item;
    boolean renameVanillaBed;
    int defaultColor;
    public static int stackSize;

    @Override
    public void setupConfig() {
        this.renameVanillaBed = this.loadPropBool("Rename vanilla bed to Red Bed", "", true);
        this.defaultColor = this.loadPropInt("Default Color", "The default color of bed to be created if wool types are mixed. 0 is white, 15 is black, 14 is vanilla red bed.", 0);
        stackSize = this.loadPropInt("Bed Stack Size", "This also changes the stack size of the vanilla bed.", 64);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        colored_bed_blocks = new Block[15];
        for (int i = 0; i < 15; ++i) {
            EnumDyeColor color = ((EnumDyeColor[])EnumDyeColor.class.getEnumConstants())[i];
            if (color == EnumDyeColor.RED) {
                color = EnumDyeColor.BLACK;
            }
            ColoredBeds.colored_bed_blocks[i] = new BlockColoredBed("colored_bed_" + color.func_176610_l(), i);
        }
        colored_bed_item = new ItemColoredBed();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Items.field_151104_aV.func_77655_b("red_bed");
        Items.field_151104_aV.func_77625_d(stackSize);
        ArrayList recipeList = new ArrayList(CraftingManager.func_77594_a().func_77592_b());
        for (IRecipe recipe : recipeList) {
            ItemStack out = recipe.func_77571_b();
            if (out == null || out.func_77973_b() != Items.field_151104_aV) continue;
            CraftingManager.func_77594_a().func_77592_b().remove(recipe);
        }
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = i == 14 ? new ItemStack(Items.field_151104_aV) : new ItemStack(colored_bed_item, 1, Math.min(14, i));
            RecipeHandler.addOreDictRecipe((ItemStack)stack, (Object[])new Object[]{"WWW", "PPP", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, i), Character.valueOf('P'), "plankWood"});
        }
        ItemStack defaultStack = new ItemStack(colored_bed_item, 1, Math.min(14, this.defaultColor));
        if (this.defaultColor == 14) {
            defaultStack = new ItemStack(Items.field_151104_aV);
        }
        RecipeHandler.addOreDictRecipe((ItemStack)defaultStack, (Object[])new Object[]{"WWW", "PPP", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), Character.valueOf('P'), "plankWood"});
    }

    public static int getColor(int colorIndex) {
        if (colorIndex >= 14) {
            colorIndex = 15;
        }
        return ItemDye.field_150922_c[15 - colorIndex];
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

