/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import com.google.common.base.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;

public class BoatSails
extends Feature {
    private static DataParameter<Optional<ItemStack>> bannerData;
    private static final String TAG_BANNER = "quark:banner";

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        bannerData = EntityDataManager.func_187226_a(EntityBoat.class, (DataSerializer)DataSerializers.field_187196_f);
    }

    @SubscribeEvent
    public void onEntityInit(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityBoat) {
            EntityDataManager manager = event.getEntity().func_184212_Q();
            manager.func_187214_a(bannerData, (Object)Optional.absent());
        }
    }

    @SubscribeEvent
    public void preUpdate(EntityEvent.CanUpdate event) {
        NBTTagCompound cmp;
        ItemStack nbtStack;
        ItemStack dataStack;
        if (event.getEntity() instanceof EntityBoat && !event.getEntity().field_70170_p.field_72995_K && (dataStack = (ItemStack)((Optional)event.getEntity().func_184212_Q().func_187225_a(bannerData)).orNull()) != (nbtStack = ItemStack.func_77949_a((NBTTagCompound)(cmp = event.getEntity().getEntityData().func_74775_l(TAG_BANNER))))) {
            event.getEntity().func_184212_Q().func_187227_b(bannerData, (Object)Optional.of((Object)nbtStack));
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        if (target instanceof EntityBoat && !target.func_184188_bt().contains(player)) {
            ItemStack banner = BoatSails.getBanner((EntityBoat)target);
            if (banner != null) {
                return;
            }
            EnumHand hand = EnumHand.MAIN_HAND;
            ItemStack stack = player.func_184614_ca();
            if (stack == null || !(stack.func_77973_b() instanceof ItemBanner)) {
                stack = player.func_184592_cb();
                hand = EnumHand.OFF_HAND;
            }
            if (stack != null && stack.func_77973_b() instanceof ItemBanner) {
                ItemStack copyStack = stack.func_77946_l();
                player.func_184609_a(hand);
                target.func_184212_Q().func_187227_b(bannerData, (Object)Optional.of((Object)copyStack));
                NBTTagCompound cmp = new NBTTagCompound();
                copyStack.func_77955_b(cmp);
                target.getEntityData().func_74782_a(TAG_BANNER, (NBTBase)cmp);
                if (!event.getWorld().field_72995_K) {
                    event.setCanceled(true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                        if (stack.field_77994_a <= 0) {
                            player.func_184611_a(hand, (ItemStack)null);
                        }
                    }
                }
            }
        }
    }

    public static ItemStack getBanner(EntityBoat boat) {
        return (ItemStack)((Optional)boat.func_184212_Q().func_187225_a(bannerData)).orNull();
    }

    public static void dropBoatBanner(EntityBoat boat) {
        if (!ModuleLoader.isFeatureEnabled(BoatSails.class)) {
            return;
        }
        ItemStack banner = BoatSails.getBanner(boat);
        if (banner != null) {
            boat.func_70099_a(banner, 0.0f);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

