/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.feature.PirateShips;

public class BuriedTreasure
extends Feature {
    public static String TAG_TREASURE_MAP = "Quark:TreasureMap";
    public static String TAG_TREASURE_MAP_DELEGATE = "Quark:TreasureMapDelegate";
    ImmutableSet<ResourceLocation> tablesToEdit = ImmutableSet.of((Object)LootTableList.field_186429_k, (Object)LootTableList.field_186430_l, (Object)LootTableList.field_186428_j);
    Map<ResourceLocation, String> customPools = new HashMap(){
        {
            this.put(PirateShips.PIRATE_CHEST_LOOT_TABLE, "quark:pirate_ship");
        }
    };
    int rarity;
    int quality;

    @Override
    public void setupConfig() {
        this.rarity = this.loadPropInt("Treasure map Rarity", "", 10);
        this.quality = this.loadPropInt("Treasure map item quality", "This is used for the luck attribute in loot tables. It doesn't affect the loot you get from the map itself.", 2);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetAsTreasureFunction.Serializer());
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation res = event.getName();
        if (this.tablesToEdit.contains((Object)res)) {
            if (this.customPools.containsKey(res)) {
                this.customPools.get(res);
            }
            event.getTable().getPool("main").addEntry((LootEntry)new LootEntryItem((Item)Items.field_151098_aY, this.rarity, this.quality, new LootFunction[]{new SetAsTreasureFunction()}, new LootCondition[0], "quark:treasure_map"));
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                int color;
                MapData data;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !stack.func_77942_o()) continue;
                if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_TREASURE_MAP_DELEGATE, (boolean)false)) {
                    this.makeMap(stack, player.field_70170_p, player.func_180425_c());
                }
                if (!ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_TREASURE_MAP, (boolean)false) || (data = (MapData)player.field_70170_p.func_72943_a(MapData.class, "map_" + stack.func_77952_i())) == null) continue;
                int w = 128;
                byte[] colors = data.field_76198_e;
                int x = w / 2;
                int y = w / 2;
                colors[this.xy((int)x, (int)y)] = color = 18;
                colors[this.xy((int)(x - 1), (int)(y - 1))] = color;
                colors[this.xy((int)(x - 2), (int)(y - 2))] = color;
                colors[this.xy((int)(x + 1), (int)(y + 1))] = color;
                colors[this.xy((int)(x + 2), (int)(y + 2))] = color;
                colors[this.xy((int)(x + 1), (int)(y - 1))] = color;
                colors[this.xy((int)(x + 2), (int)(y - 2))] = color;
                colors[this.xy((int)(x - 1), (int)(y + 1))] = color;
                colors[this.xy((int)(x - 2), (int)(y + 2))] = color;
            }
        }
    }

    public ItemStack makeMap(ItemStack itemstack, World world, BlockPos sourcePos) {
        BlockPos treasurePos;
        Random r = world.field_73012_v;
        boolean validPos = false;
        int tries = 0;
        do {
            int z;
            if (tries > 100) {
                return null;
            }
            int distance = 400 + r.nextInt(200);
            double angle = (double)r.nextFloat() * (Math.PI * 2);
            int x = (int)((double)sourcePos.func_177958_n() + Math.cos(angle) * (double)distance);
            treasurePos = world.func_175672_r(new BlockPos(x, 255, z = (int)((double)sourcePos.func_177952_p() + Math.sin(angle) * (double)distance))).func_177982_a(0, -4, 0);
            IBlockState state = world.func_180495_p(treasurePos);
            if (state.func_177230_c() == Blocks.field_150346_d) {
                validPos = true;
            }
            ++tries;
        } while (!validPos);
        String s = "map_" + itemstack.func_77960_j();
        MapData mapdata = new MapData(s);
        world.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = 1;
        mapdata.field_76201_a = treasurePos.func_177958_n();
        mapdata.field_76199_b = treasurePos.func_177952_p();
        mapdata.field_76200_c = 0;
        mapdata.field_186210_e = true;
        mapdata.func_76185_a();
        world.func_175656_a(treasurePos, Blocks.field_150486_ae.func_176223_P());
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(treasurePos);
        chest.func_189404_a(LootTableList.field_186422_d, r.nextLong());
        ItemNBTHelper.setBoolean((ItemStack)itemstack, (String)TAG_TREASURE_MAP, (boolean)true);
        ItemNBTHelper.setBoolean((ItemStack)itemstack, (String)TAG_TREASURE_MAP_DELEGATE, (boolean)false);
        return itemstack;
    }

    public int xy(int x, int y) {
        return x + y * 128;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static class SetAsTreasureFunction
    extends LootFunction {
        protected SetAsTreasureFunction() {
            super(new LootCondition[0]);
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_TREASURE_MAP_DELEGATE, (boolean)true);
            return stack;
        }

        public static class Serializer
        extends LootFunction.Serializer<SetAsTreasureFunction> {
            protected Serializer() {
                super(new ResourceLocation("Quark", "set_treasure"), SetAsTreasureFunction.class);
            }

            public void serialize(JsonObject object, SetAsTreasureFunction functionClazz, JsonSerializationContext serializationContext) {
            }

            public SetAsTreasureFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
                return new SetAsTreasureFunction();
            }
        }
    }
}

