/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.entity;

import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.sounds.QuarkSounds;
import vazkii.quark.experimental.entity.ai.EntityAITemptButNice;
import vazkii.quark.experimental.features.Frogs;
import vazkii.quark.world.entity.ai.EntityAIFavorBlock;

public class EntityFrog
extends EntityAnimal {
    public static final ResourceLocation FROG_LOOT_TABLE = new ResourceLocation("quark", "entities/frog");
    private static final DataParameter<Integer> TALK_TIME = EntityDataManager.func_187226_a(EntityFrog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151115_aP, Items.field_151070_bp});
    private static final Set<Item> TEMPTATION_ITEMS_BUT_NICE = Sets.newHashSet((Object[])new Item[]{Items.field_151115_aP, Items.field_151070_bp, Items.field_151113_aN});
    public int spawnCd = -1;
    public int spawnChain = 30;
    private int droppedLegs = -1;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;

    public EntityFrog(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.5f);
        this.field_70767_i = new FrogJumpHelper();
        this.field_70765_h = new FrogMoveHelper();
        this.setMovementSpeed(0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TALK_TIME, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic(1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITemptButNice((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS, TEMPTATION_ITEMS_BUT_NICE));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFavorBlock((EntityCreature)this, 1.0, Blocks.field_150392_bi));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.5f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public int getTalkTime() {
        return (Integer)this.field_70180_af.func_187225_a(TALK_TIME);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int talkTime = this.getTalkTime();
        if (talkTime > 0) {
            this.field_70180_af.func_187227_b(TALK_TIME, (Object)(talkTime - 1));
        }
        if (Frogs.frogsDoTheFunny && this.spawnCd > 0 && this.spawnChain > 0) {
            --this.spawnCd;
            if (this.spawnCd == 0 && !this.field_70170_p.field_72995_K) {
                float multiplier = 0.8f;
                EntityFrog newFrog = new EntityFrog(this.field_70170_p);
                newFrog.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                newFrog.field_70159_w = (Math.random() - 0.5) * (double)multiplier;
                newFrog.field_70181_x = (Math.random() - 0.5) * (double)multiplier;
                newFrog.field_70179_y = (Math.random() - 0.5) * (double)multiplier;
                this.field_70170_p.func_72838_d((Entity)newFrog);
                newFrog.spawnCd = 2;
                newFrog.spawnChain = this.spawnChain - 1;
                this.spawnChain = 0;
            }
        }
        this.field_70126_B = this.field_70758_at;
        this.field_70177_z = this.field_70759_as;
    }

    protected boolean func_146066_aG() {
        return this.spawnChain != 0;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return FROG_LOOT_TABLE;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        this.droppedLegs = 0;
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        this.droppedLegs = -1;
    }

    @Nullable
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (this.droppedLegs >= 0) {
            int count = Math.max(4 - this.droppedLegs, 0);
            this.droppedLegs += stack.func_190916_E();
            if (stack.func_190916_E() > count) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190918_g(count);
                copy.func_190925_c("display").func_74778_a("LocName", "item.quark:frog_maybe_leg.name");
                stack = stack.func_77946_l();
                stack.func_190918_g(copy.func_190916_E());
                super.func_70099_a(copy, offsetY);
            }
        }
        return super.func_70099_a(stack, offsetY);
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        if (super.func_184645_a(player, hand)) {
            return true;
        }
        Calendar calendar = this.field_70170_p.func_83015_S();
        if (Frogs.frogsDoTheFunny && calendar.get(7) == 4) {
            if (!this.field_70170_p.field_72995_K && this.spawnChain > 0) {
                this.spawnCd = 50;
                this.field_70180_af.func_187227_b(TALK_TIME, (Object)80);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, QuarkSounds.ENTITY_FROG_WEDNESDAY, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable otherParent) {
        return new EntityFrog(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        Calendar calendar = this.field_70170_p.func_83015_S();
        return !stack.func_190926_b() && (Frogs.frogsDoTheFunny && calendar.get(7) == 4 ? TEMPTATION_ITEMS_BUT_NICE : TEMPTATION_ITEMS).contains(stack.func_77973_b());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spawnCd = compound.func_74762_e("Cooldown");
        this.spawnChain = compound.func_74762_e("Chain");
        this.field_70180_af.func_187227_b(TALK_TIME, (Object)compound.func_74762_e("DudeAmount"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Cooldown", this.spawnCd);
        compound.func_74768_a("Chain", this.spawnChain);
        compound.func_74768_a("DudeAmount", this.getTalkTime());
    }

    protected SoundEvent func_184639_G() {
        return QuarkSounds.ENTITY_FROG_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_FROG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return QuarkSounds.ENTITY_FROG_DIE;
    }

    protected SoundEvent getJumpSound() {
        return QuarkSounds.ENTITY_FROG_JUMP;
    }

    public void func_70619_bc() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            FrogJumpHelper jumpHelper;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (!(jumpHelper = (FrogJumpHelper)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        vec3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                    this.startJumping();
                }
            } else if (!jumpHelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public void func_174830_Y() {
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((FrogJumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((FrogJumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (d0 > 0.0 && (d1 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.01) {
            this.func_191958_b(0.0f, 0.0f, 1.0f, 0.1f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping) {
            this.func_184185_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.func_174808_Z();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public class AIPanic
    extends EntityAIPanic {
        public AIPanic(double speedIn) {
            super((EntityCreature)EntityFrog.this, speedIn);
        }

        public void func_75246_d() {
            super.func_75246_d();
            EntityFrog.this.setMovementSpeed(this.field_75265_b);
        }
    }

    public class FrogMoveHelper
    extends EntityMoveHelper {
        private double nextJumpSpeed;

        public FrogMoveHelper() {
            super((EntityLiving)EntityFrog.this);
        }

        public void func_75641_c() {
            if (EntityFrog.this.field_70122_E && !EntityFrog.this.field_70703_bu && !((FrogJumpHelper)EntityFrog.this.field_70767_i).getIsJumping()) {
                EntityFrog.this.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                EntityFrog.this.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (EntityFrog.this.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public class FrogJumpHelper
    extends EntityJumpHelper {
        private boolean canJump;

        public FrogJumpHelper() {
            super((EntityLiving)EntityFrog.this);
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                EntityFrog.this.startJumping();
                this.field_75662_b = false;
            }
        }
    }
}

