/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.SoundEvent;
import vazkii.quark.tweaks.ai.EntityAIWantLove;

public class EntityAINuzzle
extends EntityAIBase {
    private final EntityTameable creature;
    private EntityLivingBase owner;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeUntilRebuildPath;
    private final float maxDist;
    private final float whineDist;
    private int whineCooldown;
    private float oldWaterCost;
    private final SoundEvent whine;

    public EntityAINuzzle(EntityTameable creature, double followSpeed, float maxDist, float whineDist, SoundEvent whine) {
        this.creature = creature;
        this.followSpeed = followSpeed;
        this.petPathfinder = creature.func_70661_as();
        this.maxDist = maxDist;
        this.whineDist = whineDist;
        this.whine = whine;
        this.func_75248_a(3);
        if (!(creature.func_70661_as() instanceof PathNavigateGround) && !(creature.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        if (!EntityAIWantLove.needsPets(this.creature)) {
            return false;
        }
        EntityLivingBase entitylivingbase = this.creature.func_70902_q();
        if (entitylivingbase == null || entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v() || this.creature.func_70906_o()) {
            return false;
        }
        this.owner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        if (!EntityAIWantLove.needsPets(this.creature)) {
            return false;
        }
        return !this.petPathfinder.func_75500_f() && this.creature.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.creature.func_70906_o();
    }

    public void func_75249_e() {
        this.timeUntilRebuildPath = 0;
        this.whineCooldown = 10;
        this.oldWaterCost = this.creature.func_184643_a(PathNodeType.WATER);
        this.creature.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.creature.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.creature.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.creature.func_70646_bf());
        if (!this.creature.func_70906_o() && --this.timeUntilRebuildPath <= 0) {
            this.timeUntilRebuildPath = 10;
            this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed);
        }
        if (this.creature.func_70068_e((Entity)this.owner) < (double)this.whineDist && --this.whineCooldown <= 0) {
            this.whineCooldown = 80 + this.creature.func_70681_au().nextInt(40);
            this.creature.func_184185_a(this.whine, 1.0f, 0.5f + (float)Math.random() * 0.5f);
        }
    }
}

