/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.block;

import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockMetaVariants;
import vazkii.quark.api.INonSticky;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.tweaks.feature.SpringySlime;

public class BlockColorSlime
extends BlockMetaVariants<Variants>
implements IQuarkBlock,
INonSticky {
    public BlockColorSlime() {
        super("color_slime", Material.field_151571_B, Variants.class);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149672_a(SoundType.field_185859_l);
        this.setDefaultSlipperiness(0.8f);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.func_70093_af()) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        } else {
            entityIn.func_180430_e(fallDistance, 0.0f);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (ModuleLoader.isFeatureEnabled(SpringySlime.class)) {
            SpringySlime.collideWithSlimeBlock(pos, entityIn);
        }
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        if (ModuleLoader.isFeatureEnabled(SpringySlime.class)) {
            entityIn.field_70181_x = 0.0;
        } else if (entityIn.func_70093_af()) {
            super.func_176216_a(worldIn, entityIn);
        } else if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = -entityIn.field_70181_x;
            if (!(entityIn instanceof EntityLivingBase)) {
                entityIn.field_70181_x *= 0.8;
            }
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (Math.abs(entityIn.field_70181_x) < 0.1 && !entityIn.func_70093_af()) {
            double d0 = 0.4 + Math.abs(entityIn.field_70181_x) * 0.2;
            entityIn.field_70159_w *= d0;
            entityIn.field_70179_y *= d0;
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return block != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean isStickyBlock(IBlockState state) {
        return true;
    }

    @Override
    public boolean canStickToBlock(World world, BlockPos pistonPos, BlockPos pos, BlockPos slimePos, IBlockState state, IBlockState slimeState, EnumFacing direction) {
        Variants otherVariant;
        Variants ourVariant = (Variants)((Object)state.func_177229_b((IProperty)this.variantProp));
        Block block = slimeState.func_177230_c();
        if (block == this && !ourVariant.sticksTo(otherVariant = (Variants)((Object)slimeState.func_177229_b((IProperty)this.variantProp))) && ourVariant != otherVariant) {
            return false;
        }
        if (block == Blocks.field_180399_cE) {
            return ourVariant.sticksToGreen;
        }
        return true;
    }

    public static enum Variants implements IStringSerializable
    {
        SLIME_RED(false, 3, 4),
        SLIME_BLUE(false, 2, 3),
        SLIME_CYAN(true, 1),
        SLIME_MAGENTA(false, 0, 1),
        SLIME_YELLOW(true, 0);

        public final boolean sticksToGreen;
        private final int[] sticksTo;

        private Variants(boolean sticksToGreen, int ... sticksTo) {
            this.sticksToGreen = sticksToGreen;
            this.sticksTo = sticksTo;
        }

        boolean sticksTo(Variants otherVariant) {
            int ord = otherVariant.ordinal();
            for (int i : this.sticksTo) {
                if (i != ord) continue;
                return true;
            }
            return false;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

