/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import net.minecraftforge.common.config.Property;
import vazkii.quark.base.module.ModuleLoader;

public class ConfigHelper {
    public static boolean needsRestart;
    public static boolean allNeedRestart;
    public static Property lastProp;

    public static int loadPropInt(String propName, String category, String desc, int default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        lastProp = prop;
        return prop.getInt(default_);
    }

    public static double loadPropDouble(String propName, String category, String desc, double default_, double min, double max) {
        Property prop = ModuleLoader.config.get(category, propName, default_, desc, min, max);
        ConfigHelper.setNeedsRestart(prop);
        lastProp = prop;
        return prop.getDouble(default_);
    }

    public static double loadPropDouble(String propName, String category, String desc, double default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        lastProp = prop;
        return prop.getDouble(default_);
    }

    public static boolean loadPropBool(String propName, String category, String desc, boolean default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        lastProp = prop;
        return prop.getBoolean(default_);
    }

    public static String loadPropString(String propName, String category, String desc, String default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        lastProp = prop;
        return prop.getString();
    }

    public static String[] loadPropStringList(String propName, String category, String desc, String[] default_) {
        Property prop = ModuleLoader.config.get(category, propName, default_);
        prop.setComment(desc);
        ConfigHelper.setNeedsRestart(prop);
        lastProp = prop;
        return prop.getStringList();
    }

    public static double loadPropChance(String propName, String category, String desc, double default_) {
        return ConfigHelper.loadPropDouble(propName, category, desc, default_, 0.0, 1.0);
    }

    public static double loadLegacyPropChance(String propName, String category, String oldName, String desc, double default_) {
        double chanceValue = default_;
        if (ConfigHelper.hasConfigKey(category, oldName)) {
            int value = ConfigHelper.loadPropInt(oldName, category, "", 0);
            ConfigHelper.removeKey(oldName, category);
            chanceValue = value <= 0 ? 0.0 : 1.0 / (double)value;
        }
        return ConfigHelper.loadPropChance(propName, category, desc, chanceValue);
    }

    public static boolean hasConfigKey(String propName, String category) {
        return ModuleLoader.config.hasKey(category, propName);
    }

    public static void removeKey(String propName, String category) {
        ModuleLoader.config.getCategory(category).remove((Object)propName);
    }

    private static void setNeedsRestart(Property prop) {
        if (needsRestart) {
            prop.setRequiresMcRestart(true);
        }
        needsRestart = allNeedRestart;
    }

    static {
        allNeedRestart = false;
    }
}

