/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.arl.block.BlockMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.oddities.item.ItemBlockTinyPotato;
import vazkii.quark.oddities.tile.TileTinyPotato;

public class BlockTinyPotato
extends BlockMod
implements IQuarkBlock {
    public static final PropertyEnum<EnumFacing> FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);

    public BlockTinyPotato() {
        super("tiny_potato", Material.field_151580_n, new String[0]);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.25f);
        this.func_180632_j(this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.SOUTH));
    }

    public ItemBlock createItemBlock(ResourceLocation res) {
        return new ItemBlockTinyPotato((Block)this, res);
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176736_b();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity inv = world.func_175625_s(pos);
        if (inv instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)inv));
        }
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing par6, float par7, float par8, float par9) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTinyPotato) {
            ((TileTinyPotato)tile).interact(player, hand, player.func_184586_b(hand), par6);
            world.func_175688_a(EnumParticleTypes.HEART, (double)pos.func_177958_n() + BlockTinyPotato.AABB.field_72340_a + Math.random() * (BlockTinyPotato.AABB.field_72336_d - BlockTinyPotato.AABB.field_72340_a), (double)pos.func_177956_o() + BlockTinyPotato.AABB.field_72337_e, (double)pos.func_177952_p() + BlockTinyPotato.AABB.field_72339_c + Math.random() * (BlockTinyPotato.AABB.field_72334_f - BlockTinyPotato.AABB.field_72339_c), 0.0, 0.0, 0.0, new int[0]);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a(FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileTinyPotato) {
            if (stack.func_82837_s()) {
                ((TileTinyPotato)te).name = stack.func_82833_r();
            }
            ((TileTinyPotato)te).angery = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"angery", (boolean)false);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            ItemStack stack = new ItemStack((Block)this);
            String name = ((TileTinyPotato)tile).name;
            if (!name.isEmpty()) {
                stack.func_151001_c(name);
            }
            if (((TileTinyPotato)tile).angery) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)"angery", (boolean)true);
            }
            list.add((Object)stack);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileTinyPotato();
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }
}

