/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.base;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.automation.feature.ChainLinkage;
import vazkii.quark.base.network.message.MessageSyncChain;

public class ChainHandler {
    public static final String LINKED_TO = "Quark:VehicleLink";
    public static final double DRAG = 0.95;
    public static final float CHAIN_SLACK = 2.0f;
    public static final float MAX_DISTANCE = 8.0f;
    private static final float STIFFNESS = 0.4f;
    private static final float DAMPING = 0.2f;
    private static final float MAX_FORCE = 6.0f;

    private static <T extends Entity> void adjustVelocity(T master, Entity follower) {
        if (master == follower || master.field_70170_p.field_72995_K) {
            return;
        }
        double dist = master.func_70032_d(follower);
        Vec3d masterPosition = master.func_174791_d();
        Vec3d followerPosition = follower.func_174791_d();
        Vec3d direction = followerPosition.func_178788_d(masterPosition);
        direction = direction.func_178786_a(0.0, direction.field_72448_b, 0.0).func_72432_b();
        double stretch = dist - 2.0;
        double springX = (double)0.4f * stretch * direction.field_72450_a;
        double springZ = (double)0.4f * stretch * direction.field_72449_c;
        springX = MathHelper.func_151237_a((double)springX, (double)-6.0, (double)6.0);
        springZ = MathHelper.func_151237_a((double)springZ, (double)-6.0, (double)6.0);
        master.field_70159_w += springX;
        master.field_70179_y += springZ;
        follower.field_70159_w -= springX;
        follower.field_70179_y -= springZ;
        Vec3d newMasterVelocity = new Vec3d(master.field_70159_w, 0.0, master.field_70179_y);
        Vec3d newFollowerVelocity = new Vec3d(follower.field_70159_w, 0.0, follower.field_70179_y);
        double deviation = newFollowerVelocity.func_178788_d(newMasterVelocity).func_72430_b(direction);
        double dampX = (double)0.2f * deviation * direction.field_72450_a;
        double dampZ = (double)0.2f * deviation * direction.field_72449_c;
        dampX = MathHelper.func_151237_a((double)dampX, (double)-6.0, (double)6.0);
        dampZ = MathHelper.func_151237_a((double)dampZ, (double)-6.0, (double)6.0);
        master.field_70159_w += dampX;
        master.field_70179_y += dampZ;
        follower.field_70159_w -= dampX;
        follower.field_70179_y -= dampZ;
    }

    public static UUID getLink(Entity vehicle) {
        if (!ChainHandler.canBeLinked(vehicle)) {
            return null;
        }
        if (!vehicle.getEntityData().func_186855_b(LINKED_TO)) {
            return null;
        }
        return vehicle.getEntityData().func_186857_a(LINKED_TO);
    }

    public static boolean canBeLinkedTo(Entity entity) {
        return entity instanceof EntityBoat || entity instanceof EntityMinecart || entity instanceof EntityPlayer;
    }

    public static boolean canBeLinked(Entity entity) {
        return entity instanceof EntityBoat || entity instanceof EntityMinecart;
    }

    public static <T extends Entity> Entity getLinked(T vehicle) {
        UUID uuid = ChainHandler.getLink(vehicle);
        if (uuid == null) {
            return null;
        }
        for (Entity entity : vehicle.field_70170_p.func_175647_a(Entity.class, vehicle.func_174813_aQ().func_186662_g(8.0), ChainHandler::canBeLinkedTo)) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static <T extends Entity> void adjustVehicle(T cart) {
        Entity other = ChainHandler.getLinked(cart);
        if (other == null) {
            if (ChainHandler.getLink(cart) != null) {
                ChainHandler.breakChain(cart);
            }
            return;
        }
        if (!(other instanceof EntityPlayer)) {
            ChainHandler.adjustVelocity(other, cart);
        }
        cart.field_70159_w *= 0.95;
        cart.field_70179_y *= 0.95;
    }

    private static <T extends Entity> void breakChain(T cart) {
        ChainHandler.setLink(cart, null, true);
        if (!cart.field_70170_p.field_72995_K && cart.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            cart.func_70099_a(new ItemStack(ChainLinkage.chain), 0.0f);
        }
    }

    public static void updateLinkState(Entity entity, UUID uuid, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSyncChain(entity.func_145782_y(), uuid), (EntityPlayerMP)player);
        }
    }

    public static void setLink(Entity entity, UUID uuid, boolean sync) {
        if (ChainHandler.canBeLinked(entity)) {
            if (entity.func_110124_au().equals(uuid)) {
                return;
            }
            if (uuid != null) {
                entity.getEntityData().func_186854_a(LINKED_TO, uuid);
            } else {
                entity.getEntityData().func_82580_o("Quark:VehicleLinkMost");
                entity.getEntityData().func_82580_o("Quark:VehicleLinkLeast");
            }
            if (sync && entity.field_70170_p instanceof WorldServer) {
                WorldServer world = (WorldServer)entity.field_70170_p;
                for (EntityPlayer target : world.func_73039_n().getTrackingPlayers(entity)) {
                    ChainHandler.updateLinkState(entity, uuid, target);
                }
            }
        }
    }
}

