/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.block.BlockQuarkPane;
import vazkii.quark.world.block.BlockCrystal;

public class BlockCrystalPane
extends BlockQuarkPane {
    public static final PropertyEnum<BlockCrystal.Variants> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockCrystal.Variants.class);

    private static String[] buildVariants() {
        BlockCrystal.Variants[] variantTypes = BlockCrystal.Variants.values();
        String[] variants = new String[variantTypes.length];
        for (int i = 0; i < variantTypes.length; ++i) {
            variants[i] = variantTypes[i].func_176610_l() + "_pane";
        }
        return variants;
    }

    public BlockCrystalPane() {
        super("crystal_pane", Material.field_151592_s, BlockCrystalPane.buildVariants());
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.73333335f);
        this.func_149713_g(0);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH, VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public IStateMapper getStateMapper() {
        return new StateMap.Builder().func_178440_a(VARIANT).func_178439_a("_pane").func_178442_a(this.getIgnoredProperties()).func_178441_a();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((BlockCrystal.Variants)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        BlockCrystal.Variants[] variantTypes = BlockCrystal.Variants.values();
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variantTypes[meta % variantTypes.length]));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        return ((BlockCrystal.Variants)((Object)state.func_177229_b(BlockCrystalPane.VARIANT))).color;
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean canPaneConnectTo(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return super.canPaneConnectTo(world, pos, dir) || world.func_180495_p(pos.func_177972_a(dir)).func_177230_c() instanceof BlockCrystal;
    }
}

