/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.util.EntityOpacityHandler;
import vazkii.quark.world.entity.ai.EntityAIRave;
import vazkii.quark.world.entity.ai.MovementHelperZigZag;

public class EntityCrab
extends EntityAnimal {
    public static final ResourceLocation CRAB_LOOT_TABLE = new ResourceLocation("quark", "entities/crab");
    private static final DataParameter<Float> SIZE_MODIFIER = EntityDataManager.func_187226_a(EntityCrab.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151015_O, Items.field_151115_aP, Items.field_151076_bf});
    private static int lightningCooldown;
    private boolean crabRave;
    private BlockPos jukeboxPosition;

    public EntityCrab(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.5f);
        this.field_70765_h = new MovementHelperZigZag((EntityLiving)this);
        this.field_175506_bl = Blocks.field_150354_m;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    @Nonnull
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE_MODIFIER, (Object)Float.valueOf(1.0f));
    }

    public float func_70047_e() {
        return 0.1f * this.getSizeModifier();
    }

    public float getSizeModifier() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE_MODIFIER)).floatValue();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRave(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
    }

    public boolean func_70094_T() {
        return EntityOpacityHandler.isEntityInsideOpaqueBlock((Entity)this);
    }

    public void func_70071_h_() {
        BlockPos below;
        IBlockState belowState;
        float sizeModifier;
        super.func_70071_h_();
        this.field_70138_W = this.field_70171_ac ? 1.0f : 0.6f;
        if (lightningCooldown > 0) {
            --lightningCooldown;
        }
        if (this.isRaving() && (this.jukeboxPosition == null || this.jukeboxPosition.func_177954_c(this.field_70165_t, this.field_70163_u, this.field_70161_v) > 24.0 || this.field_70170_p.func_180495_p(this.jukeboxPosition).func_177230_c() != Blocks.field_150421_aI)) {
            this.party(null, false);
        }
        if (this.field_70131_O != (sizeModifier = this.getSizeModifier()) * 0.5f) {
            this.func_70105_a(0.9f * sizeModifier, 0.5f * sizeModifier);
        }
        if (this.isRaving() && this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0 && (belowState = this.field_70170_p.func_180495_p(below = this.func_180425_c().func_177977_b())).func_185904_a() == Material.field_151595_p) {
            this.field_70170_p.func_175718_b(2001, below, Block.func_176210_f((IBlockState)belowState));
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (lightningCooldown > 0) {
            return;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Lightning Bonus", 0.5, 1));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("Lightning Bonus", 0.125, 1));
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier("Lightning Bonus", 1.0, 1));
        float sizeModifier = Math.min(this.getSizeModifier() * 2.0f, 16.0f);
        this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        this.func_70105_a(0.9f * sizeModifier, 0.5f * sizeModifier);
        lightningCooldown = 100;
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (entityIn instanceof EntityLivingBase && !(entityIn instanceof EntityCrab)) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return !stack.func_190926_b() && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable other) {
        return new EntityCrab(this.field_70170_p);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return CRAB_LOOT_TABLE;
    }

    public void party(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.crabRave = isPartying;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
        this.party(pos, isPartying);
    }

    public boolean isRaving() {
        return this.crabRave;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        lightningCooldown = compound.func_74762_e("LightningCooldown");
        if (compound.func_74764_b("EnemyCrabRating")) {
            float sizeModifier = compound.func_74760_g("EnemyCrabRating");
            this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
            this.func_70105_a(0.5f * sizeModifier, 0.9f * sizeModifier);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("EnemyCrabRating", this.getSizeModifier());
        compound.func_74768_a("LightningCooldown", lightningCooldown);
    }
}

