/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import vazkii.quark.world.feature.Wraiths;

public class EntityWraith
extends EntityZombie {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("quark:entities/wraith");
    private static final DataParameter<String> IDLE_SOUND = EntityDataManager.func_187226_a(EntityWraith.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> HURT_SOUND = EntityDataManager.func_187226_a(EntityWraith.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DEATH_SOUND = EntityDataManager.func_187226_a(EntityWraith.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final String TAG_IDLE_SOUND = "IdleSound";
    private static final String TAG_HURT_SOUND = "HurtSound";
    private static final String TAG_DEATH_SOUND = "DeathSound";

    public EntityWraith(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IDLE_SOUND, (Object)"");
        this.field_70180_af.func_187214_a(HURT_SOUND, (Object)"");
        this.field_70180_af.func_187214_a(DEATH_SOUND, (Object)"");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(field_110186_bp).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    protected void func_180481_a(@Nonnull DifficultyInstance difficulty) {
    }

    protected SoundEvent func_184639_G() {
        return this.getSound(IDLE_SOUND);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return this.getSound(HURT_SOUND);
    }

    protected SoundEvent func_184615_bR() {
        return this.getSound(DEATH_SOUND);
    }

    protected float func_70647_i() {
        return this.field_70146_Z.nextFloat() * 0.1f + 0.75f;
    }

    public SoundEvent getSound(DataParameter<String> param) {
        ResourceLocation loc = new ResourceLocation((String)this.field_70180_af.func_187225_a(param));
        return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)loc);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        AxisAlignedBB aabb = this.func_174813_aQ();
        double x = aabb.field_72340_a + Math.random() * (aabb.field_72336_d - aabb.field_72340_a);
        double y = aabb.field_72338_b + Math.random() * (aabb.field_72337_e - aabb.field_72338_b);
        double z = aabb.field_72339_c + Math.random() * (aabb.field_72334_f - aabb.field_72339_c);
        this.func_130014_f_().func_175688_a(EnumParticleTypes.TOWN_AURA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean did = super.func_70652_k(entityIn);
        if (did) {
            if (entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 1));
            }
            double dx = this.field_70165_t - entityIn.field_70165_t;
            double dz = this.field_70161_v - entityIn.field_70161_v;
            Vec3d vec = new Vec3d(dx, 0.0, dz).func_72432_b().func_72441_c(0.0, 0.5, 0.0).func_72432_b().func_186678_a(0.85);
            this.field_70159_w = vec.field_72450_a;
            this.field_70181_x = vec.field_72448_b;
            this.field_70179_y = vec.field_72449_c;
        }
        return did;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        int idx = this.field_70146_Z.nextInt(Wraiths.validWraithSounds.size());
        String sound = Wraiths.validWraithSounds.get(idx);
        String[] split = sound.split("\\|");
        this.field_70180_af.func_187227_b(IDLE_SOUND, (Object)split[0]);
        this.field_70180_af.func_187227_b(HURT_SOUND, (Object)split[1]);
        this.field_70180_af.func_187227_b(DEATH_SOUND, (Object)split[2]);
        return super.func_180482_a(difficulty, data);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a(TAG_IDLE_SOUND, (String)this.field_70180_af.func_187225_a(IDLE_SOUND));
        compound.func_74778_a(TAG_HURT_SOUND, (String)this.field_70180_af.func_187225_a(HURT_SOUND));
        compound.func_74778_a(TAG_DEATH_SOUND, (String)this.field_70180_af.func_187225_a(DEATH_SOUND));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(IDLE_SOUND, (Object)compound.func_74779_i(TAG_IDLE_SOUND));
        this.field_70180_af.func_187227_b(HURT_SOUND, (Object)compound.func_74779_i(TAG_HURT_SOUND));
        this.field_70180_af.func_187227_b(DEATH_SOUND, (Object)compound.func_74779_i(TAG_DEATH_SOUND));
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public void func_82227_f(boolean childZombie) {
    }

    public boolean func_70631_g_() {
        return false;
    }

    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b - 1.0, this.field_70161_v);
        return super.func_70601_bi() && this.func_130014_f_().func_180495_p(blockpos).func_177230_c() == Blocks.field_150425_aM;
    }
}

