/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.arl.block.BlockMod;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.block.BlockQuarkStairs;
import vazkii.quark.base.handler.ModIntegrationHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.block.BlockBasalt;
import vazkii.quark.world.block.slab.BlockBasicStoneSlab;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.RevampStoneGen;
import vazkii.quark.world.world.BasaltGenerator;

public class Basalt
extends Feature {
    public static BlockMod basalt;
    public static RevampStoneGen.StoneInfo basaltInfo;
    public static boolean enableStairsAndSlabs;
    public static boolean enableWalls;

    @Override
    public void setupConfig() {
        basaltInfo = RevampStoneGen.loadStoneInfo(this.configCategory, "basalt", 18, 20, 120, 20, true, "-1", BiomeDictionary.Type.NETHER);
        enableStairsAndSlabs = this.loadPropBool("Enable stairs and slabs", "", true) && GlobalConfig.enableVariants;
        enableWalls = this.loadPropBool("Enable walls", "", true) && GlobalConfig.enableVariants;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        basalt = new BlockBasalt();
        if (enableStairsAndSlabs) {
            BlockBasicStoneSlab.initSlab((Block)basalt, 0, "stone_basalt_slab");
            BlockModStairs.initStairs((Block)basalt, (int)0, (BlockStairs)new BlockQuarkStairs("stone_basalt_stairs", basalt.func_176223_P()));
        }
        VanillaWalls.add("basalt", (Block)basalt, 0, enableWalls);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BasaltGenerator(() -> basaltInfo), (int)0);
        Basalt.addOreDict("stoneBasalt", ProxyRegistry.newStack((Block)basalt, (int)1, (int)0));
        Basalt.addOreDict("stoneBasaltPolished", ProxyRegistry.newStack((Block)basalt, (int)1, (int)1));
    }

    @Override
    public void postPreInit() {
        Object blackItem = ProxyRegistry.newStack((Item)Items.field_151044_h);
        if (ModuleLoader.isFeatureEnabled(Biotite.class)) {
            blackItem = "gemBiotite";
        }
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)basalt, (int)4, (int)0), (Object[])new Object[]{"BI", "IB", Character.valueOf('B'), "cobblestone", Character.valueOf('I'), blackItem});
        RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_150348_b, (int)1, (int)5), (Object[])new Object[]{"stoneBasalt", "gemQuartz"});
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)basalt, (int)4, (int)1), (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), "stoneBasalt"});
    }

    @Override
    public void init() {
        ModIntegrationHandler.registerChiselVariant("basalt", new ItemStack((Block)basalt, 1, 0));
        ModIntegrationHandler.registerChiselVariant("basalt", new ItemStack((Block)basalt, 1, 1));
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

