/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public final class BlockPositions {
    private BlockPositions() {
    }

    public static BlockPos fromIntArray(int[] array) {
        if (array.length != 3) {
            throw new IllegalArgumentException();
        }
        return new BlockPos(array[0], array[1], array[2]);
    }

    public static int[] toIntArray(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    public static BlockPos readWithBase(NBTTagCompound compound, String keyBase) {
        return new BlockPos(compound.func_74762_e(keyBase + "_x"), compound.func_74762_e(keyBase + "_y"), compound.func_74762_e(keyBase + "_z"));
    }

    public static void writeToNBT(String keyBase, BlockPos coord, NBTTagCompound compound) {
        if (coord != null) {
            compound.func_74768_a(keyBase + "_x", coord.func_177958_n());
            compound.func_74768_a(keyBase + "_y", coord.func_177956_o());
            compound.func_74768_a(keyBase + "_z", coord.func_177952_p());
        }
    }

    public static BlockPos readFromNBT(String keyBase, NBTTagCompound compound) {
        return compound.func_74764_b(keyBase + "_x") && compound.func_74764_b(keyBase + "_y") && compound.func_74764_b(keyBase + "_z") ? new BlockPos(compound.func_74762_e(keyBase + "_x"), compound.func_74762_e(keyBase + "_y"), compound.func_74762_e(keyBase + "_z")) : null;
    }

    public static void maybeWriteToBuffer(BlockPos coord, ByteBuf buffer) {
        buffer.writeBoolean(coord != null);
        if (coord != null) {
            BlockPositions.writeToBuffer(coord, buffer);
        }
    }

    public static BlockPos maybeReadFromBuffer(ByteBuf buffer) {
        return buffer.readBoolean() ? BlockPositions.readFromBuffer(buffer) : null;
    }

    public static void writeToBuffer(BlockPos coord, ByteBuf buffer) {
        buffer.writeInt(coord.func_177958_n());
        buffer.writeInt(coord.func_177956_o());
        buffer.writeInt(coord.func_177952_p());
    }

    public static BlockPos readFromBuffer(ByteBuf buffer) {
        return new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static BlockPos getLowerCorner(Collection<BlockPos> positions) {
        int x = 0;
        int y = 0;
        int z = 0;
        boolean first = true;
        for (BlockPos position : positions) {
            if (first) {
                x = position.func_177958_n();
                y = position.func_177956_o();
                z = position.func_177952_p();
                first = false;
            }
            x = Math.min(x, position.func_177958_n());
            y = Math.min(y, position.func_177956_o());
            z = Math.min(z, position.func_177952_p());
        }
        if (first) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new BlockPos(x, y, z);
    }

    public static BlockPos getHigherCorner(Collection<BlockPos> positions) {
        int x = 0;
        int y = 0;
        int z = 0;
        boolean first = true;
        for (BlockPos position : positions) {
            if (first) {
                x = position.func_177958_n();
                y = position.func_177956_o();
                z = position.func_177952_p();
                first = false;
            }
            x = Math.max(x, position.func_177958_n());
            y = Math.max(y, position.func_177956_o());
            z = Math.max(z, position.func_177952_p());
        }
        if (first) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new BlockPos(x, y, z);
    }

    public static BlockPos getLowerCorner(BlockPos one, BlockPos two) {
        return new BlockPos(Math.min(one.func_177958_n(), two.func_177958_n()), Math.min(one.func_177956_o(), two.func_177956_o()), Math.min(one.func_177952_p(), two.func_177952_p()));
    }

    public static BlockPos getHigherCorner(BlockPos one, BlockPos two) {
        return new BlockPos(Math.max(one.func_177958_n(), two.func_177958_n()), Math.max(one.func_177956_o(), two.func_177956_o()), Math.max(one.func_177952_p(), two.func_177952_p()));
    }

    public static BlockPos invert(BlockPos pos) {
        return new BlockPos(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p());
    }

    public static BlockPos sub(BlockPos pos, BlockPos sub) {
        return new BlockPos(pos.func_177958_n() - sub.func_177958_n(), pos.func_177956_o() - sub.func_177956_o(), pos.func_177952_p() - sub.func_177952_p());
    }

    @Deprecated
    public static AxisAlignedBB expandToAABB(BlockPos pos, double x, double y, double z) {
        return new AxisAlignedBB(pos).func_72314_b(x, y, z);
    }
}

