/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.ivtoolkit.raytracing.IvRaytraceableAxisAlignedBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.util.vector.Vector3f;

public class IvMultiBlockHelper
implements Iterable<BlockPos> {
    private Iterator<BlockPos> iterator;
    private List<BlockPos> childLocations;
    private IvTileEntityMultiBlock parentTileEntity = null;
    private World world;
    private IBlockState blockState;
    private EnumFacing direction;
    private double[] center;
    private double[] size;

    public boolean beginPlacing(List<BlockPos> positions, World world, BlockPos pos, EnumFacing blockSide, ItemStack itemStack, EntityPlayer player, IBlockState state, EnumFacing direction) {
        List<BlockPos> validLocations = IvMultiBlockHelper.getBestPlacement(positions, world, pos, blockSide, itemStack, player, state);
        if (validLocations == null) {
            return false;
        }
        return this.beginPlacing(validLocations, world, state, direction);
    }

    public boolean beginPlacing(List<BlockPos> validLocations, World world, IBlockState state, EnumFacing direction) {
        this.world = world;
        this.parentTileEntity = null;
        this.direction = direction;
        this.blockState = state;
        this.center = IvMultiBlockHelper.getTileEntityCenter(validLocations);
        this.size = IvMultiBlockHelper.getTileEntitySize(validLocations);
        this.childLocations = validLocations;
        this.iterator = validLocations.iterator();
        return true;
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return this.iterator;
    }

    public IvTileEntityMultiBlock placeBlock(BlockPos pos) {
        return this.placeBlock(pos, this.parentTileEntity == null);
    }

    private IvTileEntityMultiBlock placeBlock(BlockPos pos, boolean parent) {
        this.world.func_180501_a(pos, this.blockState, 3);
        TileEntity tileEntity = this.world.func_175625_s(pos);
        if (tileEntity instanceof IvTileEntityMultiBlock) {
            IvTileEntityMultiBlock tileEntityMB = (IvTileEntityMultiBlock)tileEntity;
            if (parent) {
                this.parentTileEntity = tileEntityMB;
                this.childLocations.remove(this.parentTileEntity.func_174877_v());
                this.parentTileEntity.becomeParent(this.childLocations);
            } else {
                tileEntityMB.becomeChild(this.parentTileEntity);
            }
            tileEntityMB.facing = this.direction;
            tileEntityMB.centerCoords = new double[]{this.center[0] - (double)pos.func_177958_n(), this.center[1] - (double)pos.func_177956_o(), this.center[2] - (double)pos.func_177952_p()};
            tileEntityMB.centerCoordsSize = this.size;
            return tileEntityMB;
        }
        return null;
    }

    public static double[] getTileEntityCenter(List<BlockPos> positions) {
        double[] result = IvMultiBlockHelper.getCenter(positions);
        return new double[]{result[0] + 0.5, result[1] + 0.5, result[2] + 0.5};
    }

    public static double[] getTileEntitySize(List<BlockPos> positions) {
        return IvMultiBlockHelper.getSize(positions);
    }

    public static double[] getCenter(List<BlockPos> positions) {
        if (positions.size() > 0) {
            BlockPos min = BlockPositions.getLowerCorner(positions);
            BlockPos max = BlockPositions.getHigherCorner(positions);
            double[] result = new double[]{(double)(min.func_177958_n() + max.func_177958_n()) * 0.5, (double)(min.func_177956_o() + max.func_177956_o()) * 0.5, (double)(min.func_177952_p() + max.func_177952_p()) * 0.5};
            return result;
        }
        return null;
    }

    public static double[] getSize(List<BlockPos> positions) {
        if (positions.size() > 0) {
            BlockPos min = BlockPositions.getLowerCorner(positions);
            BlockPos max = BlockPositions.getHigherCorner(positions);
            double[] result = new double[]{(double)(min.func_177958_n() - max.func_177958_n() + 1) * 0.5, (double)(min.func_177956_o() - max.func_177956_o() + 1) * 0.5, (double)(min.func_177952_p() - max.func_177952_p() + 1) * 0.5};
            return result;
        }
        return null;
    }

    public static int[] getLengths(List<BlockPos> positions) {
        BlockPos min = BlockPositions.getLowerCorner(positions);
        BlockPos max = BlockPositions.getHigherCorner(positions);
        return new int[]{max.func_177958_n() - min.func_177958_n(), max.func_177956_o() - min.func_177956_o(), max.func_177952_p() - min.func_177952_p()};
    }

    public static boolean canPlace(World world, IBlockState state, List<BlockPos> positions, Entity entity, ItemStack stack) {
        for (BlockPos position : positions) {
            if (world.func_175716_a(state.func_177230_c(), position, false, EnumFacing.DOWN, entity, stack)) continue;
            return false;
        }
        return true;
    }

    public static List<List<BlockPos>> getValidPlacements(List<BlockPos> positions, World world, BlockPos pos, EnumFacing side, ItemStack itemStack, EntityPlayer player, IBlockState state) {
        IBlockState var11 = world.func_180495_p(pos);
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150431_aC && (Integer)iblockstate.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        if (!player.func_175151_a(pos, side, itemStack)) {
            return new ArrayList<List<BlockPos>>();
        }
        if (pos.func_177956_o() == world.func_72800_K() && state.func_185904_a().func_76220_a()) {
            return new ArrayList<List<BlockPos>>();
        }
        int[] lengths = IvMultiBlockHelper.getLengths(positions);
        BlockPos min = BlockPositions.getLowerCorner(positions);
        ArrayList<List<BlockPos>> validPlacements = new ArrayList<List<BlockPos>>();
        for (int xShift = min.func_177958_n() - lengths[0]; xShift <= min.func_177958_n(); ++xShift) {
            for (int yShift = min.func_177956_o() - lengths[1]; yShift <= min.func_177956_o(); ++yShift) {
                for (int zShift = min.func_177952_p() - lengths[2]; zShift <= min.func_177952_p(); ++zShift) {
                    ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
                    for (BlockPos position : positions) {
                        validPositions.add(position.func_177982_a(xShift, yShift, zShift).func_177971_a((Vec3i)pos));
                    }
                    if (!IvMultiBlockHelper.canPlace(world, state, validPositions, null, itemStack)) continue;
                    validPlacements.add(validPositions);
                }
            }
        }
        return validPlacements;
    }

    public static List<BlockPos> getBestPlacement(List<BlockPos> positions, World world, BlockPos pos, EnumFacing side, ItemStack itemStack, EntityPlayer player, IBlockState state) {
        int[] lengths = IvMultiBlockHelper.getLengths(positions);
        List<List<BlockPos>> validPlacements = IvMultiBlockHelper.getValidPlacements(positions, world, pos, side, itemStack, player, state);
        if (validPlacements.size() > 0) {
            float[] center = new float[]{(float)pos.func_177958_n() - (float)lengths[0] * 0.5f, (float)pos.func_177956_o() - (float)lengths[1] * 0.5f, (float)pos.func_177952_p() - (float)lengths[2] * 0.5f};
            List<BlockPos> preferredPositions = validPlacements.get(0);
            for (int i = 1; i < validPlacements.size(); ++i) {
                BlockPos referenceBlock = validPlacements.get(i).get(0);
                BlockPos referenceBlockOriginal = preferredPositions.get(0);
                if (!(IvMultiBlockHelper.distanceSquared(BlockPositions.toIntArray(referenceBlock), center) < IvMultiBlockHelper.distanceSquared(BlockPositions.toIntArray(referenceBlockOriginal), center))) continue;
                preferredPositions = validPlacements.get(i);
            }
            return preferredPositions;
        }
        return null;
    }

    private static float distanceSquared(int[] referenceBlock, float[] center) {
        float distX = (float)referenceBlock[0] - center[0];
        float distY = (float)referenceBlock[1] - center[1];
        float distZ = (float)referenceBlock[2] - center[2];
        return distX * distX + distY * distY + distZ * distZ;
    }

    public static List<BlockPos> getRotatedPositions(List<BlockPos> positions, EnumFacing facing) {
        ArrayList<BlockPos> returnList = new ArrayList<BlockPos>(positions.size());
        for (BlockPos position : positions) {
            switch (facing) {
                case NORTH: 
                case SOUTH: {
                    returnList.add(position);
                    break;
                }
                case WEST: 
                case EAST: {
                    returnList.add(new BlockPos(position.func_177952_p(), position.func_177956_o(), position.func_177958_n()));
                }
            }
        }
        return returnList;
    }

    public static IvRaytraceableAxisAlignedBox getRotatedBox(Object userInfo, double x, double y, double z, double width, double height, double depth, EnumFacing direction, double[] centerCoords) {
        IvRaytraceableAxisAlignedBox box = null;
        switch (direction) {
            case SOUTH: {
                box = new IvRaytraceableAxisAlignedBox(userInfo, centerCoords[0] - x - width, centerCoords[1] + y, centerCoords[2] + z, width, height, depth);
                break;
            }
            case WEST: {
                box = new IvRaytraceableAxisAlignedBox(userInfo, centerCoords[0] - z - depth, centerCoords[1] + y, centerCoords[2] - x - width, depth, height, width);
                break;
            }
            case NORTH: {
                box = new IvRaytraceableAxisAlignedBox(userInfo, centerCoords[0] + x, centerCoords[1] + y, centerCoords[2] - z - depth, width, height, depth);
                break;
            }
            case EAST: {
                box = new IvRaytraceableAxisAlignedBox(userInfo, centerCoords[0] + z, centerCoords[1] + y, centerCoords[2] + x, depth, height, width);
            }
        }
        return box;
    }

    public static AxisAlignedBB getRotatedBB(double x, double y, double z, double width, double height, double depth, EnumFacing direction, double[] centerCoords) {
        AxisAlignedBB box = null;
        switch (direction) {
            case SOUTH: {
                box = IvMultiBlockHelper.getBBWithLengths(centerCoords[0] + x, centerCoords[1] + y, centerCoords[2] + z, width, height, depth);
                break;
            }
            case WEST: {
                box = IvMultiBlockHelper.getBBWithLengths(centerCoords[0] - z - depth, centerCoords[1] + y, centerCoords[2] + x, depth, height, width);
                break;
            }
            case NORTH: {
                box = IvMultiBlockHelper.getBBWithLengths(centerCoords[0] - x - width, centerCoords[1] + y, centerCoords[2] - z - depth, width, height, depth);
                break;
            }
            case EAST: {
                box = IvMultiBlockHelper.getBBWithLengths(centerCoords[0] + z, centerCoords[1] + y, centerCoords[2] - x - width, depth, height, width);
            }
        }
        return box;
    }

    public static Vector3f getRotatedVector(Vector3f vector3f, EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return new Vector3f(vector3f.x, vector3f.y, vector3f.z);
            }
            case WEST: {
                return new Vector3f(-vector3f.z, vector3f.y, vector3f.x);
            }
            case NORTH: {
                return new Vector3f(-vector3f.x, vector3f.y, -vector3f.z);
            }
            case EAST: {
                return new Vector3f(vector3f.z, vector3f.y, -vector3f.x);
            }
        }
        return null;
    }

    public static Vec3d getRotatedVector(Vec3d vec3, EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return new Vec3d(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
            }
            case WEST: {
                return new Vec3d(-vec3.field_72449_c, vec3.field_72448_b, vec3.field_72450_a);
            }
            case NORTH: {
                return new Vec3d(-vec3.field_72450_a, vec3.field_72448_b, -vec3.field_72449_c);
            }
            case EAST: {
                return new Vec3d(vec3.field_72449_c, vec3.field_72448_b, -vec3.field_72450_a);
            }
        }
        return null;
    }

    public static AxisAlignedBB getBBWithLengths(double x, double y, double z, double width, double height, double depth) {
        return new AxisAlignedBB(x, y, z, x + width, y + height, z + depth);
    }

    public static EnumFacing getRotation(Entity entity) {
        return entity.func_174811_aO();
    }

    public static List<BlockPos> getRotatedPositions(EnumFacing facing, int width, int height, int length) {
        boolean affectsX = facing == EnumFacing.SOUTH || facing == EnumFacing.NORTH;
        return IvMultiBlockHelper.getPositions(affectsX ? width : length, height, affectsX ? length : width);
    }

    public static List<BlockPos> getPositions(int width, int height, int length) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return positions;
    }
}

