/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.blocks.IvMultiBlockHelper;
import ivorius.ivtoolkit.blocks.IvTileEntityHelper;
import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.raytracing.IvRaytraceableAxisAlignedBox;
import ivorius.ivtoolkit.tools.EnumFacingHelper;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.util.vector.Vector3f;

public class IvTileEntityMultiBlock
extends TileEntity {
    public BlockPos parentCoords;
    public BlockPos[] childCoords;
    public EnumFacing facing;
    public double[] centerCoords = new double[]{0.5, 0.5, 0.5};
    public double[] centerCoordsSize = new double[]{0.5, 0.5, 0.5};
    public boolean multiblockInvalid;

    public BlockPos getActiveParentCoords() {
        if (this.parentCoords == null) {
            return this.func_174877_v();
        }
        return this.func_174877_v().func_177982_a(this.parentCoords.func_177958_n(), this.parentCoords.func_177956_o(), this.parentCoords.func_177952_p());
    }

    public BlockPos[] getActiveChildCoords() {
        if (this.childCoords == null) {
            return new BlockPos[0];
        }
        BlockPos[] returnVal = new BlockPos[this.childCoords.length];
        for (int i = 0; i < returnVal.length; ++i) {
            returnVal[i] = this.func_174877_v().func_177971_a((Vec3i)this.childCoords[i]);
        }
        return returnVal;
    }

    public double[] getActiveCenterCoords() {
        if (this.centerCoords == null) {
            return new double[]{(double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5};
        }
        return new double[]{(double)this.func_174877_v().func_177958_n() + this.centerCoords[0], (double)this.func_174877_v().func_177956_o() + this.centerCoords[1], (double)this.func_174877_v().func_177952_p() + this.centerCoords[2]};
    }

    public void becomeChild(TileEntity parent) {
        this.parentCoords = parent != null ? BlockPositions.sub(parent.func_174877_v(), this.func_174877_v()) : null;
    }

    public void becomeParent(List<BlockPos> childCoords) {
        if (childCoords != null) {
            this.childCoords = new BlockPos[childCoords.size()];
            for (int i = 0; i < childCoords.size(); ++i) {
                this.childCoords[i] = BlockPositions.sub(childCoords.get(i), this.func_174877_v());
            }
        } else {
            this.childCoords = new BlockPos[0];
        }
    }

    public boolean isParent() {
        return this.parentCoords == null;
    }

    public IvTileEntityMultiBlock getTotalParent() {
        return this.isParent() ? this : this.getParent();
    }

    public IvTileEntityMultiBlock getParent() {
        TileEntity parentTileEntity;
        if (this.parentCoords != null && (parentTileEntity = this.field_145850_b.func_175625_s(this.getActiveParentCoords())) != null && ((Object)((Object)this)).getClass().equals(parentTileEntity.getClass())) {
            return (IvTileEntityMultiBlock)parentTileEntity;
        }
        return null;
    }

    public float getDistanceToCenter() {
        return (float)IvVecMathHelper.distance(new double[]{(double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5}, this.getActiveCenterCoords());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_150297_b("direction", 3)) {
            switch (tagCompound.func_74762_e("direction")) {
                case 0: {
                    this.facing = EnumFacing.SOUTH;
                }
                case 1: {
                    this.facing = EnumFacing.WEST;
                }
                case 2: {
                    this.facing = EnumFacing.NORTH;
                }
                case 3: {
                    this.facing = EnumFacing.EAST;
                }
            }
            this.facing = EnumFacing.SOUTH;
        } else {
            this.facing = EnumFacingHelper.byName(tagCompound.func_74779_i("facing"), EnumFacing.SOUTH);
        }
        this.centerCoords = IvNBTHelper.readDoubleArray("multiBlockCenter", tagCompound);
        if (this.centerCoords == null) {
            this.centerCoords = new double[3];
            this.centerCoords[0] = tagCompound.func_74764_b("centerCoords[0]") ? tagCompound.func_74769_h("centerCoords[0]") - (double)this.func_174877_v().func_177958_n() : 0.5;
            this.centerCoords[1] = tagCompound.func_74764_b("centerCoords[1]") ? tagCompound.func_74769_h("centerCoords[1]") - (double)this.func_174877_v().func_177956_o() : 0.5;
            this.centerCoords[2] = tagCompound.func_74764_b("centerCoords[2]") ? tagCompound.func_74769_h("centerCoords[2]") - (double)this.func_174877_v().func_177952_p() : 0.5;
        }
        this.centerCoordsSize = IvNBTHelper.readDoubleArray("multiBlockSize", tagCompound);
        if (this.centerCoordsSize == null) {
            this.centerCoordsSize = new double[3];
            this.centerCoordsSize[0] = tagCompound.func_74764_b("centerCoordsSize[0]") ? (double)tagCompound.func_74760_g("centerCoordsSize[0]") : 0.5;
            this.centerCoordsSize[1] = tagCompound.func_74764_b("centerCoordsSize[1]") ? (double)tagCompound.func_74760_g("centerCoordsSize[1]") : 0.5;
            this.centerCoordsSize[2] = tagCompound.func_74764_b("centerCoordsSize[2]") ? (double)tagCompound.func_74760_g("centerCoordsSize[2]") : 0.5;
        }
        this.parentCoords = tagCompound.func_74764_b("parentCoords") ? BlockPositions.fromIntArray(IvNBTHelper.readIntArrayFixedSize("parentCoords", 3, tagCompound)) : null;
        if (tagCompound.func_74764_b("childCoords")) {
            int[] childCoordsCut = tagCompound.func_74759_k("childCoords");
            this.childCoords = new BlockPos[childCoordsCut.length / 3];
            for (int i = 0; i < this.childCoords.length; ++i) {
                this.childCoords[i] = new BlockPos(childCoordsCut[i * 3], childCoordsCut[i * 3 + 1], childCoordsCut[i * 3 + 2]);
            }
        } else if (this.parentCoords == null) {
            this.childCoords = new BlockPos[0];
        }
        this.multiblockInvalid = tagCompound.func_74767_n("multiblockInvalid");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74778_a("facing", this.facing.func_176610_l());
        IvNBTHelper.writeDoubleArray("multiBlockCenter", this.centerCoords, tagCompound);
        IvNBTHelper.writeDoubleArray("multiBlockSize", this.centerCoordsSize, tagCompound);
        if (this.parentCoords != null) {
            tagCompound.func_74783_a("parentCoords", BlockPositions.toIntArray(this.parentCoords));
        }
        if (this.childCoords != null) {
            int[] childCoordsCut = new int[this.childCoords.length * 3];
            for (int i = 0; i < this.childCoords.length; ++i) {
                childCoordsCut[i * 3] = this.childCoords[i].func_177958_n();
                childCoordsCut[i * 3 + 1] = this.childCoords[i].func_177956_o();
                childCoordsCut[i * 3 + 2] = this.childCoords[i].func_177952_p();
            }
            tagCompound.func_74783_a("childCoords", childCoordsCut);
        }
        return tagCompound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return IvTileEntityHelper.getStandardDescriptionPacket(this);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public IvRaytraceableAxisAlignedBox getInterpolatedRotatedBox(Object userInfo, double x, double y, double z, double width, double height, double depth, double x1, double y1, double z1, double width1, double height1, double depth1, float fraction) {
        double xI = IvMathHelper.mix(x, x1, (double)fraction);
        double yI = IvMathHelper.mix(y, y1, (double)fraction);
        double zI = IvMathHelper.mix(z, z1, (double)fraction);
        double wI = IvMathHelper.mix(width, width1, (double)fraction);
        double hI = IvMathHelper.mix(height, height1, (double)fraction);
        double dI = IvMathHelper.mix(depth, depth1, (double)fraction);
        return this.getRotatedBox(userInfo, xI, yI, zI, wI, hI, dI);
    }

    public IvRaytraceableAxisAlignedBox getRotatedBox(Object userInfo, double x, double y, double z, double width, double height, double depth) {
        return IvMultiBlockHelper.getRotatedBox(userInfo, x, y, z, width, height, depth, this.getFacing(), this.getActiveCenterCoords());
    }

    public AxisAlignedBB getRotatedBB(double x, double y, double z, double width, double height, double depth) {
        return IvMultiBlockHelper.getRotatedBB(x, y, z, width, height, depth, this.getFacing(), this.getActiveCenterCoords());
    }

    public Vector3f getRotatedVector(Vector3f vector3f) {
        return IvMultiBlockHelper.getRotatedVector(vector3f, this.getFacing());
    }

    public Vec3d getRotatedVector(Vec3d vec3) {
        return IvMultiBlockHelper.getRotatedVector(vec3, this.getFacing());
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public AxisAlignedBB getBoxAroundCenter(double width, double height, double length) {
        double[] center = this.getActiveCenterCoords();
        return new AxisAlignedBB(center[0] - width, center[1] - height, center[2] - length, center[0] + width, center[1] + height, center[2] + length);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.isParent()) {
            return this.getBoxAroundCenter(0.0, 0.0, 0.0);
        }
        return this.getBoxAroundCenter(this.centerCoordsSize[0], this.centerCoordsSize[1], this.centerCoordsSize[2]);
    }
}

