/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering.grid;

import ivorius.ivtoolkit.blocks.BlockArea;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AreaRenderer {
    public static void renderAreaLined(BlockArea area, float sizeP) {
        AreaRenderer.renderArea(area, true, false, sizeP);
    }

    public static void renderArea(BlockArea area, boolean lined, boolean insides, float sizeP) {
        AreaRenderer.drawCuboid(area.getLowerCorner(), area.getHigherCorner().func_177982_a(1, 1, 1), lined, insides, sizeP);
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawCuboid(BlockPos min, BlockPos max, boolean lined, boolean insides, float sizeP) {
        float width2 = ((float)max.func_177958_n() - (float)min.func_177958_n()) * 0.5f;
        float height2 = ((float)max.func_177956_o() - (float)min.func_177956_o()) * 0.5f;
        float length2 = ((float)max.func_177952_p() - (float)min.func_177952_p()) * 0.5f;
        double centerX = (float)min.func_177958_n() + width2;
        double centerY = (float)min.func_177956_o() + height2;
        double centerZ = (float)min.func_177952_p() + length2;
        int sizeCE = insides ? -1 : 1;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)centerX, (double)centerY, (double)centerZ);
        if (lined) {
            GlStateManager.func_179090_x();
            AreaRenderer.drawLineCuboid(Tessellator.func_178181_a().func_178180_c(), width2 + sizeP, height2 + sizeP, length2 + sizeP, 1.0f);
            GlStateManager.func_179098_w();
        } else {
            AreaRenderer.drawCuboid(Tessellator.func_178181_a().func_178180_c(), width2 * (float)sizeCE + sizeP, height2 * (float)sizeCE + sizeP, length2 * (float)sizeCE + sizeP, 1.0f);
        }
        GlStateManager.func_179121_F();
    }

    public static void drawCuboid(VertexBuffer renderer, float sizeX, float sizeY, float sizeZ, float in) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(-sizeX * in), (double)(-sizeY * in), (double)(-sizeZ)).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(sizeY * in), (double)(-sizeZ)).func_187315_a(0.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(sizeY * in), (double)(-sizeZ)).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(-sizeY * in), (double)(-sizeZ)).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(-sizeY * in), (double)sizeZ).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(-sizeY * in), (double)sizeZ).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(sizeY * in), (double)sizeZ).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(sizeY * in), (double)sizeZ).func_187315_a(0.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX), (double)(-sizeY * in), (double)(-sizeZ * in)).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX), (double)(-sizeY * in), (double)(sizeZ * in)).func_187315_a(0.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX), (double)(sizeY * in), (double)(sizeZ * in)).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX), (double)(sizeY * in), (double)(-sizeZ * in)).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)sizeX, (double)(-sizeY * in), (double)(-sizeZ * in)).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)sizeX, (double)(sizeY * in), (double)(-sizeZ * in)).func_187315_a(0.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)sizeX, (double)(sizeY * in), (double)(sizeZ * in)).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)sizeX, (double)(-sizeY * in), (double)(sizeZ * in)).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)sizeY, (double)(-sizeZ * in)).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)sizeY, (double)(sizeZ * in)).func_187315_a(0.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)sizeY, (double)(sizeZ * in)).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)sizeY, (double)(-sizeZ * in)).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(-sizeY), (double)(-sizeZ * in)).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(-sizeY), (double)(-sizeZ * in)).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(-sizeY), (double)(sizeZ * in)).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(-sizeY), (double)(sizeZ * in)).func_187315_a(0.0, 1.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawLineCuboid(VertexBuffer renderer, float sizeX, float sizeY, float sizeZ, float in) {
        renderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b((double)(-sizeX * in), (double)(-sizeY * in), (double)(-sizeZ)).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(sizeY * in), (double)(-sizeZ)).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(sizeY * in), (double)(-sizeZ)).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(-sizeY * in), (double)(-sizeZ)).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(-sizeY * in), (double)(-sizeZ)).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(-sizeY * in), (double)sizeZ).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(sizeY * in), (double)sizeZ).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(sizeY * in), (double)sizeZ).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(-sizeY * in), (double)sizeZ).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(-sizeY * in), (double)sizeZ).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        renderer.func_181662_b((double)(-sizeX * in), (double)(sizeY * in), (double)(-sizeZ)).func_181675_d();
        renderer.func_181662_b((double)(-sizeX * in), (double)(sizeY * in), (double)sizeZ).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(sizeY * in), (double)(-sizeZ)).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(sizeY * in), (double)sizeZ).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(-sizeY * in), (double)(-sizeZ)).func_181675_d();
        renderer.func_181662_b((double)(sizeX * in), (double)(-sizeY * in), (double)sizeZ).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

