/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.block;

import io.netty.buffer.ByteBuf;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.utils.accessor.RCAccessorCommandBase;
import java.text.SimpleDateFormat;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandListener;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SpawnCommandLogic
implements ICommandSender {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private String commandStored = "";
    private String customName = "@";
    private final CommandResultStats resultStats = new CommandResultStats();

    public NBTTagCompound writeToNBT(NBTTagCompound p_189510_1_) {
        p_189510_1_.func_74778_a("Command", this.commandStored);
        p_189510_1_.func_74778_a("CustomName", this.customName);
        this.resultStats.func_179670_b(p_189510_1_);
        return p_189510_1_;
    }

    public void readDataFromNBT(NBTTagCompound nbt) {
        this.commandStored = nbt.func_74779_i("Command");
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.resultStats.func_179668_a(nbt);
    }

    public boolean func_70003_b(int permLevel, String commandName) {
        return permLevel <= 2;
    }

    public void setCommand(String command) {
        this.commandStored = command;
    }

    public String getCommand() {
        return this.commandStored;
    }

    public void trigger(World worldIn) {
        MinecraftServer minecraftserver;
        if (!worldIn.field_72995_K && (minecraftserver = this.func_184102_h()) != null && minecraftserver.func_175578_N() && minecraftserver.func_82356_Z()) {
            ICommandManager icommandmanager = minecraftserver.func_71187_D();
            ICommandListener cachedAdmin = null;
            if (!RCConfig.notifyAdminOnBlockCommands) {
                cachedAdmin = RCAccessorCommandBase.getCommandAdmin();
                CommandBase.func_71529_a(null);
            }
            try {
                icommandmanager.func_71556_a((ICommandSender)this, this.commandStored);
            }
            catch (Exception ex) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)ex, (String)"Executing command block");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Command to be executed");
                crashreportcategory.func_189529_a("Command", this::getCommand);
                crashreportcategory.func_189529_a("Name", this::func_70005_c_);
                throw new ReportedException(crashreport);
            }
            if (!RCConfig.notifyAdminOnBlockCommands) {
                CommandBase.func_71529_a((ICommandListener)cachedAdmin);
            }
        }
    }

    public String func_70005_c_() {
        return this.customName;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public void setName(String name) {
        this.customName = name;
    }

    public void func_145747_a(ITextComponent component) {
    }

    public boolean func_174792_t_() {
        MinecraftServer minecraftserver = this.func_184102_h();
        return minecraftserver == null || !minecraftserver.func_175578_N() || minecraftserver.field_71305_c[0].func_82736_K().func_82766_b("commandBlockOutput");
    }

    public void func_174794_a(CommandResultStats.Type type, int amount) {
        this.resultStats.func_184932_a(this.func_184102_h(), (ICommandSender)this, type, amount);
    }

    public abstract void updateCommand();

    @SideOnly(value=Side.CLIENT)
    public abstract int getCommandBlockType();

    @SideOnly(value=Side.CLIENT)
    public abstract void fillInInfo(ByteBuf var1);

    public CommandResultStats getCommandResultStats() {
        return this.resultStats;
    }
}

