/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.commands.parameters.IvP;
import ivorius.reccomplex.commands.parameters.expect.IvE;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.commands.structure.sight.CommandSightCheck;
import ivorius.reccomplex.random.Person;
import ivorius.reccomplex.shadow.mcopts.commands.CommandSplit;
import ivorius.reccomplex.shadow.mcopts.commands.SimpleCommand;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.utils.RCBlockAreas;
import ivorius.reccomplex.utils.RCStrings;
import ivorius.reccomplex.utils.RCStructureBoundingBoxes;
import ivorius.reccomplex.utils.accessor.RCAccessorMapGenStructure;
import ivorius.reccomplex.utils.accessor.SafeReflector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CommandVanilla
extends CommandSplit {
    private static Method recursiveGenerate;

    public CommandVanilla() {
        super(RCConfig.commandPrefix + "vanilla");
        this.add(new SimpleCommand("gen", expect -> expect.any((Object[])Type.values()).then(IvE.surfacePos("x", "z")).named("dimension", "d").then(MCE::dimension).named("seed", new String[0]).then(RCE::randomString).named("biome", "b").then(MCE::biome).flag("select", "s").flag("suggest", "t")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Parameters parameters = Parameters.of(args, this.expect()::declare);
                Type type = parameters.get(0).map(Type::fromName, s -> new CommandException("No such structure type", new Object[0])).require();
                WorldServer world = (WorldServer)parameters.get("dimension").to(MCP.dimension(server, sender)).require();
                BlockSurfacePos pos = (BlockSurfacePos)parameters.get(IvP.surfacePos("x", "z", sender.func_180425_c(), false)).require();
                String seed = parameters.get("seed").optional().orElseGet(() -> Person.chaoticName(new Random(), new Random().nextBoolean()));
                boolean suggest = parameters.has("suggest");
                Biome biome = parameters.get("biome").to(MCP::biome).optional().orElse(null);
                BiomeProvider biomeProvider = null;
                if (biome != null) {
                    biomeProvider = world.field_73011_w.func_177499_m();
                    CommandVanilla.setBiomeProvider(world.field_73011_w, (BiomeProvider)new BiomeProviderSingle(biome));
                }
                try {
                    MapGenStructure gen = type.generator(suggest);
                    ChunkPos chunkPos = pos.chunkCoord();
                    Random random = new Random(RCStrings.seed(seed));
                    ReflectionHelper.setPrivateValue(MapGenBase.class, (Object)gen, (Object)random, (String[])new String[]{"rand", "field_75038_b"});
                    CommandVanilla.recursiveGenerate((MapGenBase)gen, (World)world, chunkPos);
                    Long2ObjectMap structureMap = (Long2ObjectMap)ReflectionHelper.getPrivateValue(MapGenStructure.class, (Object)gen, (String[])new String[]{"structureMap", "field_75053_d"});
                    StructureStart structureStart = (StructureStart)structureMap.get(ChunkPos.func_77272_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b));
                    if (structureStart == null || !RCStructureBoundingBoxes.valid(structureStart.func_75071_a())) {
                        throw new CommandException("Failed to place structure!", new Object[0]);
                    }
                    for (ChunkPos retroPos : RCStructureBoundingBoxes.rasterize(structureStart.func_75071_a(), true)) {
                        gen.func_175794_a((World)world, random, retroPos);
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Structure generated at %s with seed %s", new Object[]{RCTextStyle.chunkPos(chunkPos), RCTextStyle.copy(seed)}));
                    if (parameters.has("select")) {
                        RCCommands.select(sender, RCBlockAreas.from(structureStart.func_75071_a()));
                    }
                }
                finally {
                    if (biomeProvider != null) {
                        CommandVanilla.setBiomeProvider(world.field_73011_w, biomeProvider);
                    }
                }
            }
        });
        this.add(new SimpleCommand("check", expect -> expect.then(MCE::xyz)){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Parameters parameters = Parameters.of(args, this.expect()::declare);
                World world = sender.func_130014_f_();
                BlockPos pos = (BlockPos)parameters.get(MCP.pos("x", "y", "z", sender.func_180425_c(), false)).require();
                sender.func_145747_a(CommandSightCheck.list(CommandVanilla.sightNames(world, pos)));
            }
        });
    }

    public static void setBiomeProvider(WorldProvider provider, BiomeProvider biomeProvider) {
        ReflectionHelper.setPrivateValue(WorldProvider.class, (Object)provider, (Object)biomeProvider, (String[])new String[]{"field_76578_c", "biomeProvider"});
    }

    public static List<ITextComponent> sightNames(World world, BlockPos pos) {
        List sights = CommandVanilla.sights(world, pos).map(RCTextStyle::vanillaSight).collect(Collectors.toCollection(ArrayList::new));
        sights.addAll(CommandVanilla.sights(world, pos).map(s -> RCAccessorMapGenStructure.getStructureAt(s, pos)).flatMap(s -> s.func_186161_c().stream().filter(c -> c.func_74874_b().func_175898_b((Vec3i)pos))).map(RCTextStyle::vanillaComponentSight).collect(Collectors.toList()));
        return sights;
    }

    public static Stream<MapGenStructure> sights(World world, BlockPos pos) {
        return Arrays.stream(Type.values()).map(t -> t.generator(false)).peek(m -> ReflectionHelper.setPrivateValue(MapGenBase.class, (Object)m, (Object)world, (String[])new String[]{"worldObj", "field_75039_c"})).filter(m -> m.func_175795_b(pos));
    }

    public static Stream<StructureComponent> sights(StructureStart structure, BlockPos pos) {
        return structure.func_186161_c().stream().filter(s -> s.func_74874_b().func_175898_b((Vec3i)pos));
    }

    public static void recursiveGenerate(MapGenBase gen, World world, ChunkPos pos) {
        ChunkPrimer primer = new ChunkPrimer();
        if (recursiveGenerate == null) {
            recursiveGenerate = ReflectionHelper.findMethod(MapGenBase.class, null, (String[])new String[]{"recursiveGenerate", "func_180701_a"}, (Class[])new Class[]{World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, ChunkPrimer.class});
        }
        ReflectionHelper.setPrivateValue(MapGenBase.class, (Object)gen, (Object)world, (String[])new String[]{"world", "field_75039_c"});
        SafeReflector.invoke(gen, recursiveGenerate, null, world, pos.field_77276_a, pos.field_77275_b, 0, 0, primer);
    }

    public static enum Type {
        VILLAGE,
        MINESHAFT,
        STRONGHOLD,
        TEMPLE,
        OCEAN_MONUMENT,
        NETHER_STRONGHOLD;


        public static Type fromName(String name) {
            return Arrays.stream(Type.values()).filter(t -> t.structureName().equals(name)).findFirst().orElse(null);
        }

        public String structureName() {
            return this.generator(false).func_143025_a();
        }

        public MapGenStructure generator(final boolean suggest) {
            switch (this) {
                case VILLAGE: {
                    return new MapGenVillage(){

                        protected boolean func_75047_a(int chunkX, int chunkZ) {
                            return !suggest || super.func_75047_a(chunkX, chunkZ);
                        }
                    };
                }
                case MINESHAFT: {
                    return new MapGenMineshaft(){

                        protected boolean func_75047_a(int chunkX, int chunkZ) {
                            return !suggest || super.func_75047_a(chunkX, chunkZ);
                        }
                    };
                }
                case STRONGHOLD: {
                    return new MapGenStronghold(){

                        protected boolean func_75047_a(int chunkX, int chunkZ) {
                            return !suggest || super.func_75047_a(chunkX, chunkZ);
                        }
                    };
                }
                case TEMPLE: {
                    return new MapGenScatteredFeature(){

                        protected boolean func_75047_a(int chunkX, int chunkZ) {
                            return !suggest || super.func_75047_a(chunkX, chunkZ);
                        }
                    };
                }
                case OCEAN_MONUMENT: {
                    return new StructureOceanMonument(){

                        protected boolean func_75047_a(int chunkX, int chunkZ) {
                            return !suggest || super.func_75047_a(chunkX, chunkZ);
                        }
                    };
                }
                case NETHER_STRONGHOLD: {
                    return new MapGenNetherBridge(){

                        protected boolean func_75047_a(int chunkX, int chunkZ) {
                            return !suggest || super.func_75047_a(chunkX, chunkZ);
                        }
                    };
                }
            }
            throw new InternalError();
        }

        public String toString() {
            return this.structureName();
        }
    }
}

