/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.parameters;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.CommandVirtual;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.files.loading.ResourceDirectory;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameter;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.Expressions;
import ivorius.reccomplex.utils.expression.ResourceExpression;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.NaturalGeneration;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;

public class RCP {
    public static Parameter<Structure<?>> structure(Parameter<String> p) {
        return p.map(StructureRegistry.INSTANCE::get, t -> RecurrentComplex.translations.commandException("commands.strucGen.noStructure", p.get()));
    }

    public static Parameter<GenericStructure> genericStructure(Parameter<String> p, boolean copy) {
        return p.map(id -> {
            Structure structure = (Structure)StructureRegistry.INSTANCE.get((String)id);
            if (structure == null) {
                throw RecurrentComplex.translations.commandException("commands.structure.notRegistered", id);
            }
            if (copy) {
                structure = structure.copyAsGenericStructure();
            }
            if (!(structure instanceof GenericStructure)) {
                throw RecurrentComplex.translations.commandException("commands.structure.notGeneric", id);
            }
            return (GenericStructure)structure;
        });
    }

    public static Parameter<GenericStructure> structureFromBlueprint(Parameter<String> p, ICommandSender sender) {
        return RCP.genericStructure(p, true).map(GenericStructure::copyAsGenericStructure).orElseGet(() -> {
            GenericStructure structure = GenericStructure.createDefaultStructure();
            structure.metadata.authors = sender.func_70005_c_();
            return structure;
        });
    }

    public static Parameter<GenerationType> generationType(Parameter<String> p, Structure<?> structure) {
        return p.map(structure::generationType, t -> RecurrentComplex.translations.commandException("No Generation by this ID", new Object[0])).orElseGet(() -> structure.generationTypes(NaturalGeneration.class).stream().findFirst().orElse(structure.generationTypes(GenerationType.class).stream().findFirst().orElse(null)));
    }

    public static Parameter<Predicate<Structure>> structurePredicate(Parameter<String> p) {
        return p.to(RCP::expression, new ResourceExpression(s1 -> !s1.isEmpty())).map(m -> s -> m.test(StructureRegistry.INSTANCE.resourceLocation(s)));
    }

    public static Parameter<ResourceDirectory> resourceDirectory(Parameter<String> p) {
        return p.map(t -> {
            try {
                return ResourceDirectory.valueOf(t);
            }
            catch (IllegalArgumentException e) {
                throw RecurrentComplex.translations.commandException("commands.rcsave.nodirectory", new Object[0]);
            }
        });
    }

    public static Parameter<int[]> metadatas(Parameter<String> p) {
        return p.map(arg -> {
            try {
                String[] strings = arg.split(",");
                int[] ints = new int[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    ints[i] = Integer.valueOf(strings[i]);
                }
                return ints;
            }
            catch (Exception ex) {
                throw RecurrentComplex.translations.wrongUsageException("commands.selectModify.invalidMetadata", arg);
            }
        });
    }

    public static <T extends ExpressionCache<I>, I> Parameter<T> expression(Parameter<String> p, T t) {
        return p.map(s -> {
            ExpressionCache cache = ExpressionCache.of(t, s);
            RCCommands.ensureValid(cache, p.name(0));
            return cache;
        });
    }

    public static Parameter<CommandVirtual> virtualCommand(Parameter<String> p, MinecraftServer server) {
        return p.to(MCP::command, server).map(c -> {
            if (!(c instanceof CommandVirtual)) {
                throw RecurrentComplex.translations.commandException("commands.rcmap.nonvirtual", new Object[0]);
            }
            return (CommandVirtual)c;
        });
    }

    public static Parameter<List<EnumFacing>> directions(Parameter<String> parameter) {
        return parameter.to(RCP::expression, Expressions.direction()).map(Expressions::directions);
    }

    public static Parameter<Shape> shape(Parameter<String> parameter) {
        return parameter.map(Shape::valueOf, s -> new CommandException("Invalid Shape!", new Object[0]));
    }

    public static enum Shape {
        cube,
        sphere;

    }
}

