/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.events.handlers;

import ivorius.reccomplex.world.gen.feature.decoration.RCBiomeDecorator;
import ivorius.reccomplex.world.gen.feature.sapling.RCSaplingGenerator;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RCTerrainGenEventHandler {
    private static boolean hasAmountData(DecorateBiomeEvent.Decorate event) {
        try {
            event.getClass().getDeclaredMethod("getModifiedAmount", new Class[0]);
            event.getClass().getDeclaredMethod("setModifiedAmount", Integer.TYPE);
            return (Boolean)event.getClass().getDeclaredMethod("hasAmountData", new Class[0]).invoke((Object)event, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int getModifiedAmount(DecorateBiomeEvent.Decorate event) {
        try {
            return (Integer)event.getClass().getDeclaredMethod("getModifiedAmount", new Class[0]).invoke((Object)event, new Object[0]);
        }
        catch (Exception ignored) {
            return -1;
        }
    }

    private static void setModifiedAmount(DecorateBiomeEvent.Decorate event, int amount) {
        try {
            event.getClass().getDeclaredMethod("setModifiedAmount", Integer.TYPE).invoke((Object)event, amount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void register() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onSaplingGrow(SaplingGrowTreeEvent event) {
        if (event.getWorld() instanceof WorldServer && RCSaplingGenerator.maybeGrowSapling((WorldServer)event.getWorld(), event.getPos(), event.getRand())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onDecoration(DecorateBiomeEvent.Decorate event) {
        if (event.getWorld() instanceof WorldServer) {
            RCBiomeDecorator.DecorationType type;
            switch (event.getType()) {
                case BIG_SHROOM: {
                    type = RCBiomeDecorator.DecorationType.BIG_SHROOM;
                    break;
                }
                case TREE: {
                    type = RCBiomeDecorator.DecorationType.TREE;
                    break;
                }
                case CACTUS: {
                    type = RCBiomeDecorator.DecorationType.CACTUS;
                    break;
                }
                case FOSSIL: {
                    type = RCBiomeDecorator.DecorationType.FOSSIL;
                    break;
                }
                case DESERT_WELL: {
                    type = RCBiomeDecorator.DecorationType.DESERT_WELL;
                    break;
                }
                default: {
                    type = null;
                }
            }
            if (type != null) {
                int amount;
                if (RCTerrainGenEventHandler.hasAmountData(event) && (amount = RCTerrainGenEventHandler.getModifiedAmount(event)) >= 0) {
                    RCTerrainGenEventHandler.setModifiedAmount(event, RCBiomeDecorator.decorate((WorldServer)event.getWorld(), event.getRand(), event.getPos(), type, amount));
                } else {
                    Event.Result result = RCBiomeDecorator.decorate((WorldServer)event.getWorld(), event.getRand(), event.getPos(), type);
                    if (result != null) {
                        event.setResult(result);
                    }
                }
            }
        }
    }
}

