/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.files.loading.ResourceDirectory;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.utils.SaveDirectoryData;
import java.util.function.Supplier;
import net.minecraft.util.text.TextFormatting;

public class TableElementSaveDirectory {
    public static TitledCell create(SaveDirectoryData data, Supplier<String> idSupplier, TableDelegate delegate) {
        String id = idSupplier.get();
        TableCellEnum<ResourceDirectory> cellFolder = new TableCellEnum<ResourceDirectory>("activeFolder", data.getDirectory(), TableCellEnum.options(ResourceDirectory.values(), d -> TextFormatting.GREEN + d.readableName(), null));
        cellFolder.addPropertyConsumer(cell -> {
            data.setDirectory((ResourceDirectory)((Object)((Object)cellFolder.getPropertyValue())));
            delegate.reloadData();
        });
        if (data.getDirectory().isActive() ? data.getFilesInInactive().contains(id) : data.getFilesInActive().contains(id)) {
            String path = data.getDirectory().opposite().subDirectoryName();
            TableCellBoolean cellDelete = new TableCellBoolean("deleteOther", data.isDeleteOther(), IvTranslations.format("reccomplex.structure.deleteOther.true", TextFormatting.RED, TextFormatting.RESET, String.format("%s/%s%s", TextFormatting.AQUA, path, TextFormatting.RESET)), IvTranslations.format("reccomplex.structure.deleteOther.false", TextFormatting.YELLOW, TextFormatting.RESET));
            cellDelete.addPropertyConsumer(cell -> data.setDeleteOther((Boolean)cellDelete.getPropertyValue()));
            cellDelete.setTooltip(IvTranslations.formatLines("reccomplex.structure.deleteOther.tooltip", TextFormatting.AQUA + ResourceDirectory.INACTIVE.subDirectoryName() + TextFormatting.RESET, TextFormatting.AQUA + ResourceDirectory.ACTIVE.subDirectoryName() + TextFormatting.RESET));
            return new TitledCell(new TableCellMulti(cellFolder, cellDelete));
        }
        return new TitledCell(new TableCellMulti(cellFolder, new TableCellButton("", "", "-", false)));
    }
}

