/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.client.rendering.MazeVisualizationContext;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.TableElementSaveDirectory;
import ivorius.reccomplex.gui.editstructure.TableDataSourceGenerationType;
import ivorius.reccomplex.gui.editstructure.TableDataSourceGenericVariableDomain;
import ivorius.reccomplex.gui.editstructure.TableDataSourceMetadata;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TableCellMultiBuilder;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSupplied;
import ivorius.reccomplex.utils.SaveDirectoryData;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import javax.annotation.Nonnull;

public class TableDataSourceGenericStructure
extends TableDataSourceSegmented {
    protected GenericStructure structureInfo;
    protected String structureKey;
    protected SaveDirectoryData saveDirectoryData;
    protected TableDelegate tableDelegate;
    protected TableNavigator navigator;

    public TableDataSourceGenericStructure(GenericStructure structureInfo, String structureKey, SaveDirectoryData saveDirectoryData, TableDelegate delegate, TableNavigator navigator, MazeVisualizationContext visualizationContext) {
        this.structureInfo = structureInfo;
        this.structureKey = structureKey;
        this.saveDirectoryData = saveDirectoryData;
        this.tableDelegate = delegate;
        this.navigator = navigator;
        this.addManagedSegment(1, new TableDataSourceSupplied(() -> TableElementSaveDirectory.create(saveDirectoryData, () -> structureKey, delegate)));
        this.addManagedSegment(2, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceMetadata(structureInfo.metadata)).buildDataSource(IvTranslations.get("reccomplex.structure.metadata"), IvTranslations.getLines("reccomplex.structure.metadata.tooltip")));
        this.addManagedSegment(4, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceGenerationType(structureInfo.generationTypes, visualizationContext, delegate, navigator)).buildDataSource(IvTranslations.get("reccomplex.structure.generation"), IvTranslations.getLines("reccomplex.structure.generation.tooltip")));
        this.addManagedSegment(5, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> structureInfo.transformer.tableDataSource(navigator, delegate)).buildDataSource(IvTranslations.get("reccomplex.structure.transformers"), IvTranslations.getLines("reccomplex.structure.transformers.tooltip")));
        this.addManagedSegment(6, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceGenericVariableDomain(delegate, navigator, structureInfo.variableDomain)).buildDataSource(IvTranslations.get("reccomplex.structure.variables"), IvTranslations.getLines("reccomplex.structure.variables.tooltip")));
        this.addManagedSegment(7, TableDataSourceExpression.constructDefault(IvTranslations.get("reccomplex.structure.dependencies"), IvTranslations.getLines("reccomplex.structure.dependencies.tooltip"), structureInfo.dependencies, RecurrentComplex.saver));
    }

    public GenericStructure getStructureInfo() {
        return this.structureInfo;
    }

    public void setStructureInfo(GenericStructure structureInfo) {
        this.structureInfo = structureInfo;
    }

    public String getStructureKey() {
        return this.structureKey;
    }

    public void setStructureKey(String structureKey) {
        this.structureKey = structureKey;
    }

    public SaveDirectoryData getSaveDirectoryData() {
        return this.saveDirectoryData;
    }

    public void setSaveDirectoryData(SaveDirectoryData saveDirectoryData) {
        this.saveDirectoryData = saveDirectoryData;
    }

    public TableDelegate getTableDelegate() {
        return this.tableDelegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.tableDelegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }

    @Override
    @Nonnull
    public String title() {
        return "Generic Structure";
    }

    @Override
    public int numberOfSegments() {
        return 8;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 0: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 0: {
                if (index == 0) {
                    TableCellString cell2 = new TableCellString(null, this.structureKey);
                    cell2.addPropertyConsumer(cell1 -> {
                        this.structureKey = (String)cell2.getPropertyValue();
                        cell2.setValidityState(this.currentNameState());
                        TableCells.reloadExcept(this.tableDelegate, "structureID");
                    });
                    cell2.setShowsValidityState(true);
                    cell2.setValidityState(this.currentNameState());
                    return new TitledCell("structureID", IvTranslations.get("reccomplex.structure.id"), cell2).withTitleTooltip(IvTranslations.formatLines("reccomplex.structure.id.tooltip", new Object[0]));
                }
            }
            case 3: {
                if (index == 0) {
                    TableCellBoolean cellRotatable = new TableCellBoolean("rotatable", this.structureInfo.rotatable, IvTranslations.get("reccomplex.structure.rotatable.true"), IvTranslations.get("reccomplex.structure.rotatable.false"));
                    cellRotatable.setTooltip(IvTranslations.formatLines("reccomplex.structure.rotatable.tooltip", new Object[0]));
                    cellRotatable.addPropertyConsumer(cell -> {
                        this.structureInfo.rotatable = (Boolean)cellRotatable.getPropertyValue();
                    });
                    TableCellBoolean cellMirrorable = new TableCellBoolean("mirrorable", this.structureInfo.mirrorable, IvTranslations.format("reccomplex.structure.mirrorable.true", new Object[0]), IvTranslations.format("reccomplex.structure.mirrorable.false", new Object[0]));
                    cellMirrorable.setTooltip(IvTranslations.formatLines("reccomplex.structure.mirrorable.tooltip", new Object[0]));
                    cellMirrorable.addPropertyConsumer(cell -> {
                        this.structureInfo.mirrorable = (Boolean)cellMirrorable.getPropertyValue();
                    });
                    return new TitledCell(new TableCellMulti(cellRotatable, cellMirrorable));
                }
                if (index != 1) break;
                TableCellBoolean cellBlocking = new TableCellBoolean("blocking", this.structureInfo.blocking, IvTranslations.format("reccomplex.structure.blocking.true", new Object[0]), IvTranslations.format("reccomplex.structure.blocking.false", new Object[0]));
                cellBlocking.setTooltip(IvTranslations.formatLines("reccomplex.structure.blocking.tooltip", new Object[0]));
                cellBlocking.addPropertyConsumer(cell -> {
                    this.structureInfo.blocking = (Boolean)cellBlocking.getPropertyValue();
                });
                return new TitledCell(cellBlocking);
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }

    private GuiValidityStateIndicator.State currentNameState() {
        return Structures.isSimpleID(this.structureKey) ? (StructureRegistry.INSTANCE.ids().contains(this.structureKey) ? GuiValidityStateIndicator.State.SEMI_VALID : GuiValidityStateIndicator.State.VALID) : GuiValidityStateIndicator.State.INVALID;
    }
}

