/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellFloat;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.utils.scale.Scales;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericVariableDomain;
import javax.annotation.Nonnull;

public class TableDataSourceGenericVariable
extends TableDataSourceSegmented {
    private GenericVariableDomain.Variable variable;
    private TableDelegate tableDelegate;

    public TableDataSourceGenericVariable(GenericVariableDomain.Variable variable) {
        this.variable = variable;
        this.addManagedSegment(1, TableDataSourceExpression.constructDefault(IvTranslations.get("reccomplex.structure.variables.condition"), variable.condition, null));
    }

    @Override
    @Nonnull
    public String title() {
        return "Variable";
    }

    @Override
    public int numberOfSegments() {
        return 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 0 ? 3 : super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            if (index == 0) {
                TableCellString cell = new TableCellString(null, this.variable.id);
                cell.setShowsValidityState(true);
                cell.addPropertyConsumer(s -> {
                    if (Structures.isSimpleID(s)) {
                        cell.setValidityState(GuiValidityStateIndicator.State.VALID);
                        this.variable.id = s;
                    } else {
                        cell.setValidityState(GuiValidityStateIndicator.State.INVALID);
                    }
                });
                return new TitledCell(IvTranslations.get("reccomplex.structure.variables.id"), cell).withTitleTooltip(IvTranslations.getLines("reccomplex.structure.variables.id.tooltip"));
            }
            if (index == 1) {
                TableCellFloat cell = new TableCellFloat(null, this.variable.chance, 0.0f, 1.0f);
                cell.setScale(Scales.pow(5.0f));
                cell.addPropertyConsumer(f -> {
                    this.variable.chance = f.floatValue();
                });
                return new TitledCell(IvTranslations.get("reccomplex.structure.variables.chance"), cell).withTitleTooltip(IvTranslations.getLines("reccomplex.structure.variables.chance.tooltip"));
            }
            if (index == 2) {
                TableCellBoolean cell = new TableCellBoolean(null, this.variable.affectsLogic);
                cell.addPropertyConsumer(b -> {
                    this.variable.affectsLogic = b;
                });
                return new TitledCell(IvTranslations.get("reccomplex.structure.variables.logical"), cell).withTitleTooltip(IvTranslations.getLines("reccomplex.structure.variables.logical.tooltip"));
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

