/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TableCellInteger;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.NaturalGeneration;

public class TableDataSourceNaturalGenLimitation
extends TableDataSourceSegmented {
    private NaturalGeneration.SpawnLimitation limitation;
    private TableDelegate tableDelegate;

    public TableDataSourceNaturalGenLimitation(NaturalGeneration.SpawnLimitation limitation, TableDelegate tableDelegate) {
        this.limitation = limitation;
        this.tableDelegate = tableDelegate;
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            switch (index) {
                case 0: {
                    TableCellEnum<NaturalGeneration.SpawnLimitation.Context> cell = new TableCellEnum<NaturalGeneration.SpawnLimitation.Context>("context", this.limitation.context, TableCellEnum.options((Enum[])NaturalGeneration.SpawnLimitation.Context.values(), (String)"reccomplex.generationInfo.natural.limitation.context.", (boolean)false));
                    cell.addPropertyConsumer(val -> {
                        this.limitation.context = val;
                        this.tableDelegate.reloadData();
                    });
                    return new TitledCell("Context", cell);
                }
                case 1: {
                    TableCellInteger cell = new TableCellInteger("max", this.limitation.maxCount, 1, 50);
                    cell.addPropertyConsumer(val -> {
                        this.limitation.maxCount = val;
                    });
                    return new TitledCell("Max Occurrences", cell);
                }
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

