/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.transformers;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceTransformer;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellFloat;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.utils.scale.Scales;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerNaturalAir;

public class TableDataSourceBTNaturalAir
extends TableDataSourceSegmented {
    private TransformerNaturalAir transformer;

    public TableDataSourceBTNaturalAir(TransformerNaturalAir transformer, TableNavigator navigator, TableDelegate delegate) {
        this.transformer = transformer;
        this.addManagedSegment(0, new TableDataSourceTransformer(transformer, delegate, navigator));
        this.addManagedSegment(1, TableDataSourceExpression.constructDefault(IvTranslations.get("reccomplex.gui.sources"), IvTranslations.getLines("reccomplex.transformer.block.source.tooltip"), transformer.sourceMatcher, null));
        this.addManagedSegment(2, TableDataSourceExpression.constructDefault(IvTranslations.get("reccomplex.gui.destinations"), IvTranslations.getLines("reccomplex.transformer.block.dest.tooltip"), transformer.destMatcher, null));
    }

    public TransformerNaturalAir getTransformer() {
        return this.transformer;
    }

    public void setTransformer(TransformerNaturalAir transformer) {
        this.transformer = transformer;
    }

    @Override
    public int numberOfSegments() {
        return 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 3 ? 2 : super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 3) {
            switch (index) {
                case 0: {
                    TableCellFloat cell = new TableCellFloat("naturalExpansionDistance", TableCells.toFloat(this.transformer.naturalExpansionDistance).floatValue(), 0.0f, 40.0f);
                    cell.setScale(Scales.pow(5.0f));
                    cell.addPropertyConsumer(val -> {
                        this.transformer.naturalExpansionDistance = TableCells.toDouble(val);
                    });
                    return new TitledCell(IvTranslations.get("reccomplex.transformer.naturalAir.naturalExpansionDistance"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.naturalAir.naturalExpansionDistance.tooltip", new Object[0]));
                }
                case 1: {
                    TableCellFloat cell = new TableCellFloat("naturalExpansionRandomization", TableCells.toFloat(this.transformer.naturalExpansionRandomization).floatValue(), 0.0f, 40.0f);
                    cell.setScale(Scales.pow(5.0f));
                    cell.addPropertyConsumer(val -> {
                        this.transformer.naturalExpansionRandomization = TableCells.toDouble(val);
                    });
                    return new TitledCell(IvTranslations.get("reccomplex.transformer.naturalAir.naturalExpansionRandomization"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.naturalAir.naturalExpansionRandomization.tooltip", new Object[0]));
                }
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

