/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCellActionListener;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellPropertyDefault;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiButton;

public class TableCellPresetAction
extends TableCellPropertyDefault<String> {
    public static final int DIRECTION_BUTTON_WIDTH = 20;
    protected GuiButton leftButton;
    protected GuiButton rightButton;
    protected final List<TableCellButton> actions = new ArrayList<TableCellButton>();

    public TableCellPresetAction(String id, List<TableCellButton> actions) {
        super(id, actions.size() > 0 ? actions.get((int)0).actionID : "");
        this.actions.addAll(actions);
        this.setPropertyValue((String)this.property);
    }

    public static Stream<TableCellButton> sorted(Stream<TableCellButton> actions) {
        return actions.sorted((o1, o2) -> o1.title.compareTo(o2.title));
    }

    public void addListener(TableCellActionListener listener) {
        this.actions.forEach(a -> a.addListener(listener));
    }

    public TableCellActionListener addAction(Consumer<String> consumer) {
        TableCellActionListener listener = (cell, action) -> consumer.accept(action);
        this.actions.forEach(a -> a.addListener(listener));
        return listener;
    }

    public void removeListener(TableCellActionListener listener) {
        this.actions.forEach(a -> a.removeListener(listener));
    }

    public List<TableCellButton> getActions() {
        return this.actions;
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        int buttonY = bounds.getMinY() + (bounds.getHeight() - 20) / 2;
        int presetButtonWidth = bounds.getWidth() - 40;
        boolean canChange = this.actions.size() > 1 || this.actions.size() == 1 && !Objects.equals(this.getPropertyValue(), this.actions.get((int)0).actionID);
        this.leftButton = new GuiButton(-1, bounds.getMinX(), buttonY, 19, 20, "<");
        this.leftButton.field_146125_m = !this.isHidden();
        this.leftButton.field_146124_l = canChange;
        screen.addButton(this, 0, this.leftButton);
        this.rightButton = new GuiButton(-1, bounds.getMinX() + 20 + presetButtonWidth + 1, buttonY, 19, 20, ">");
        this.rightButton.field_146125_m = !this.isHidden();
        this.rightButton.field_146124_l = canChange;
        screen.addButton(this, 1, this.rightButton);
        for (TableCellButton action : this.actions) {
            action.initGui(screen);
        }
    }

    @Override
    public void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        int buttonY = bounds.getMinY() + (bounds.getHeight() - 20) / 2;
        int directionButtonWidth = 20;
        int presetButtonWidth = bounds.getWidth() - directionButtonWidth * 2;
        this.actions.forEach(a -> a.setBounds(Bounds.fromSize(bounds.getMinX() + directionButtonWidth + 1, buttonY, presetButtonWidth - 2, 20)));
    }

    @Override
    public void setHidden(boolean hidden) {
        TableCellButton action;
        super.setHidden(hidden);
        if (this.leftButton != null) {
            boolean bl = this.leftButton.field_146125_m = !hidden;
        }
        if (this.rightButton != null) {
            boolean bl = this.rightButton.field_146125_m = !hidden;
        }
        if ((action = this.findAction((String)this.getPropertyValue())) != null) {
            action.setHidden(hidden);
        }
    }

    @Override
    public void buttonClicked(int buttonID) {
        super.buttonClicked(buttonID);
        if (buttonID == 0 || buttonID == 1) {
            this.move(buttonID == 0 ? -1 : 1);
        }
    }

    @Override
    public void setPropertyValue(String value) {
        super.setPropertyValue(value);
        if (this.actions != null) {
            this.actions.forEach(a -> a.setHidden(true));
            TableCellButton actionB = this.findAction(value);
            if (actionB != null) {
                actionB.setHidden(this.isHidden());
            }
        }
    }

    public void move(int plus) {
        this.setPropertyValue(this.actions.get((int)(((this.findIndex((String)((String)this.getPropertyValue())) + plus) % this.actions.size() + this.actions.size()) % this.actions.size())).actionID);
    }

    @Override
    public void draw(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        super.draw(screen, mouseX, mouseY, partialTicks);
        TableCellButton action = this.findAction((String)this.getPropertyValue());
        if (action != null) {
            action.draw(screen, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void drawFloating(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        super.drawFloating(screen, mouseX, mouseY, partialTicks);
        TableCellButton action = this.findAction((String)this.getPropertyValue());
        if (action != null) {
            action.drawFloating(screen, mouseX, mouseY, partialTicks);
        }
    }

    public TableCellButton findAction(String actionID) {
        int index = this.findIndex(actionID);
        return index >= 0 ? this.actions.get(index) : null;
    }

    protected int findIndex(String actionID) {
        int currentIndex = -1;
        for (int i = 0; i < this.actions.size(); ++i) {
            TableCellButton action = this.actions.get(i);
            if (!action.actionID.equals(actionID)) continue;
            currentIndex = i;
        }
        return currentIndex;
    }
}

