/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCellPropertyDefault;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiTextField;

public abstract class TableCellTextField<T>
extends TableCellPropertyDefault<T> {
    @Nullable
    protected GuiTextField textField;
    @Nullable
    protected GuiValidityStateIndicator stateIndicator;
    protected boolean showsValidityState;
    protected boolean validDataType = true;
    protected GuiValidityStateIndicator.State validityState = GuiValidityStateIndicator.State.VALID;
    protected int maxStringLength = 300;
    @Nullable
    protected Runnable changeListener;
    protected boolean enabled = true;

    public TableCellTextField(String id, T value) {
        super(id, value);
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        if (this.textField != null) {
            this.textField.func_146203_f(maxStringLength);
        }
    }

    @Nullable
    public Runnable getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(@Nullable Runnable changeListener) {
        this.changeListener = changeListener;
    }

    @Nullable
    public GuiTextField getTextField() {
        return this.textField;
    }

    @Nullable
    public GuiValidityStateIndicator getStateIndicator() {
        return this.stateIndicator;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.textField != null) {
            this.textField.func_146184_c(enabled);
        }
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        if (this.textField == null) {
            this.textField = new GuiTextField(0, this.getFontRenderer(), 0, 0, 0, 0);
        }
        this.updateTextFieldBounds(bounds);
        this.textField.func_146203_f(this.maxStringLength);
        this.textField.func_146180_a(this.serialize(this.getPropertyValue()));
        this.textField.func_146189_e(!this.isHidden());
        this.textField.func_146184_c(this.enabled);
        if (this.showsValidityState()) {
            this.stateIndicator = new GuiValidityStateIndicator(bounds.getMaxX() - 12, bounds.getCenterY() - 5, GuiValidityStateIndicator.State.UNKNWON);
            this.updateValidityStateIndicator();
            this.stateIndicator.setVisible(!this.isHidden());
        } else {
            this.stateIndicator = null;
        }
    }

    protected abstract String serialize(T var1);

    @Nullable
    protected abstract T deserialize(String var1);

    @Override
    public void draw(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        super.draw(screen, mouseX, mouseY, partialTicks);
        this.textField.func_146194_f();
        if (this.stateIndicator != null) {
            this.stateIndicator.draw();
        }
    }

    @Override
    public void update(GuiTable screen) {
        super.update(screen);
        this.textField.func_146178_a();
    }

    @Override
    public boolean keyTyped(char keyChar, int keyCode) {
        super.keyTyped(keyChar, keyCode);
        boolean used = this.textField.func_146201_a(keyChar, keyCode);
        T cur = this.deserialize(this.textField.func_146179_b());
        if (cur != null) {
            this.validDataType = true;
            Object prev = this.property;
            this.property = cur;
            if (!cur.equals(prev)) {
                this.alertListenersOfChange();
            }
            if (this.changeListener != null) {
                this.changeListener.run();
            }
        } else {
            this.validDataType = false;
        }
        this.updateValidityStateIndicator();
        return used;
    }

    @Override
    public void mouseClicked(int button, int x, int y) {
        super.mouseClicked(button, x, y);
        this.textField.func_146192_a(x, y, button);
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.textField != null) {
            this.textField.func_146189_e(!hidden);
        }
        if (this.stateIndicator != null) {
            this.stateIndicator.setVisible(!hidden);
        }
    }

    @Override
    public void setPropertyValue(T t) {
        super.setPropertyValue(t);
        if (this.textField != null) {
            this.textField.func_146180_a(this.serialize(t));
        }
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    protected void updateTextFieldBounds(Bounds bounds) {
        if (this.textField != null) {
            Bounds.set(this.textField, Bounds.fromSize(bounds.getMinX() + 2, bounds.getCenterY() - 9, bounds.getWidth() - (this.showsValidityState() ? 14 : 0) - 4, 18));
        }
    }

    @Override
    public void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        this.updateTextFieldBounds(bounds);
    }

    protected void updateValidityStateIndicator() {
        if (this.stateIndicator != null) {
            this.stateIndicator.setState(!this.validDataType ? GuiValidityStateIndicator.State.INVALID : this.validityState);
        }
    }

    public GuiValidityStateIndicator.State getValidityState() {
        return this.validityState;
    }

    public void setValidityState(GuiValidityStateIndicator.State validityState) {
        this.validityState = validityState;
        this.updateValidityStateIndicator();
    }

    public boolean showsValidityState() {
        return this.showsValidityState;
    }

    public void setShowsValidityState(boolean showsValidityState) {
        this.showsValidityState = showsValidityState;
    }
}

