/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts;

import ivorius.reccomplex.block.TileEntityBlockScript;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSupplied;
import ivorius.reccomplex.gui.worldscripts.multi.TableDataSourceWorldScriptMulti;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;

public class TableDataSourceScriptBlock
extends TableDataSourceSegmented {
    public TileEntityBlockScript script;

    public TableDataSourceScriptBlock(TileEntityBlockScript script, TableDelegate delegate, TableNavigator navigator) {
        this.script = script;
        this.addManagedSegment(0, new TableDataSourceSupplied(() -> {
            TableCellBoolean spawn = new TableCellBoolean(null, script.spawnTriggerable);
            spawn.addPropertyConsumer(b -> {
                script.spawnTriggerable = b;
            });
            spawn.setTrueTitle(TextFormatting.GREEN + "Spawn");
            spawn.setFalseTitle(TextFormatting.GRAY + "Spawn");
            TableCellBoolean redstone = new TableCellBoolean(null, script.redstoneTriggerable);
            redstone.addPropertyConsumer(b -> {
                script.redstoneTriggerable = b;
            });
            redstone.setTrueTitle(TextFormatting.GREEN + "Redstone");
            redstone.setFalseTitle(TextFormatting.GRAY + "Redstone");
            return new TitledCell("Triggerable", new TableCellMulti(spawn, redstone));
        }));
        this.addManagedSegment(1, new TableDataSourceWorldScriptMulti(script.script, script.func_174877_v(), delegate, navigator));
    }

    @Override
    @Nonnull
    public String title() {
        return "Script Block";
    }
}

