/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.command;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.RCGuiTables;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellPresetAction;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.script.WorldScriptCommand;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;

public class TableDataSourceSpawnCommandEntry
extends TableDataSourceSegmented {
    private WorldScriptCommand.Entry entry;
    private TableDelegate tableDelegate;

    public TableDataSourceSpawnCommandEntry(WorldScriptCommand.Entry entry, TableDelegate tableDelegate) {
        this.entry = entry;
        this.tableDelegate = tableDelegate;
    }

    @Override
    @Nonnull
    public String title() {
        return "Command";
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return 3;
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (index == 0) {
            TableCellPresetAction cell = new TableCellPresetAction("default", Arrays.asList(new TableCellButton("", "spawner", Blocks.field_150474_ac.func_149732_F()), new TableCellButton("", "entity", IvTranslations.get("reccomplex.spawncommand.preset.entity"))));
            cell.addAction(action -> {
                if ("spawner".equals(action)) {
                    this.entry.command = "/setblock ~ ~ ~ mob_spawner 0 replace {SpawnData:{id:Zombie}}";
                } else if ("entity".equals(action)) {
                    this.entry.command = "/summon Zombie ~ ~ ~";
                }
                this.tableDelegate.reloadData();
            });
            return new TitledCell(IvTranslations.get("reccomplex.preset"), cell);
        }
        if (index == 1) {
            TableCellString cell = new TableCellString("command", this.entry.command);
            cell.setMaxStringLength(Short.MAX_VALUE);
            cell.addPropertyConsumer(val -> {
                this.entry.command = val;
            });
            return new TitledCell(IvTranslations.get("reccomplex.gui.command"), cell);
        }
        if (index == 2) {
            return RCGuiTables.defaultWeightElement(val -> {
                this.entry.weight = TableCells.toDouble(val);
            }, this.entry.weight);
        }
        return null;
    }
}

