/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import com.google.common.collect.Lists;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.reccomplex.client.rendering.MazeVisualizationContext;
import ivorius.reccomplex.gui.GuiHider;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceList;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazePath;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazePathConnection;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazePathConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;

public class TableDataSourceMazePathConnectionList
extends TableDataSourceList<SavedMazePathConnection, List<SavedMazePathConnection>> {
    private Selection bounds;
    protected MazeVisualizationContext visualizationContext;

    public TableDataSourceMazePathConnectionList(List<SavedMazePathConnection> list, TableDelegate tableDelegate, TableNavigator navigator, Selection bounds) {
        super(list, tableDelegate, navigator);
        this.bounds = bounds;
        this.duplicateTitle = TextFormatting.GREEN + "D";
    }

    public TableDataSourceMazePathConnectionList visualizing(MazeVisualizationContext context) {
        this.visualizationContext = context;
        return this;
    }

    @Override
    public String getDisplayString(SavedMazePathConnection mazePath) {
        return String.format("%s %s%s%s", Arrays.toString(mazePath.path.sourceRoom.getCoordinates()), TextFormatting.BLUE, TableDataSourceMazePath.directionFromPath(mazePath.path).toString(), TextFormatting.RESET);
    }

    @Override
    public SavedMazePathConnection newEntry(String actionID) {
        return new SavedMazePathConnection(2, new MazeRoom(new int[this.bounds.dimensions]), false, "Path", Collections.emptyList());
    }

    @Override
    public SavedMazePathConnection copyEntry(SavedMazePathConnection mazePath) {
        return mazePath.copy();
    }

    @Override
    @Nonnull
    public TableCell entryCell(boolean enabled, SavedMazePathConnection savedMazePathConnection) {
        return TableCells.edit(enabled, this.navigator, this.tableDelegate, () -> new TableDataSourceMazePathConnection(savedMazePathConnection, this.bounds, this.visualizationContext, this.tableDelegate, this.navigator));
    }

    @Override
    @Nonnull
    public String title() {
        return "Paths";
    }

    @Override
    public boolean canVisualize() {
        return this.visualizationContext != null;
    }

    @Override
    public GuiHider.Visualizer visualizer() {
        return TableDataSourceMazePath.visualizePaths(this.visualizationContext, Lists.transform((List)this.list, p -> p.path));
    }
}

