/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.client.rendering.MazeVisualizationContext;
import ivorius.reccomplex.gui.TableDataSourceBlockPos;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellInteger;
import ivorius.reccomplex.gui.table.cell.TableCellMultiBuilder;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.worldscripts.TableDataSourceWorldScript;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazeComponent;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.rules.TableDataSourceMazeRuleList;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.MazeGeneration;
import ivorius.reccomplex.world.gen.script.WorldScriptMazeGenerator;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TableDataSourceWorldScriptMazeGenerator
extends TableDataSourceSegmented {
    private WorldScriptMazeGenerator script;
    protected TableDelegate delegate;
    protected TableNavigator navigator;

    public TableDataSourceWorldScriptMazeGenerator(WorldScriptMazeGenerator script, BlockPos realWorldPos, TableDelegate delegate, TableNavigator navigator) {
        this.script = script;
        this.delegate = delegate;
        this.navigator = navigator;
        this.addManagedSegment(0, new TableDataSourceWorldScript(script));
        this.addManagedSegment(2, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceMazeComponent(script.mazeComponent, navigator, delegate).visualizing(new MazeVisualizationContext(script.structureShift.func_177971_a((Vec3i)realWorldPos), script.roomSize)), () -> IvTranslations.get("reccomplex.maze")).buildDataSource());
        this.addManagedSegment(3, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceMazeRuleList(script.rules, delegate, navigator, script.mazeComponent.exitPaths, script.mazeComponent.rooms), () -> IvTranslations.get("reccomplex.worldscript.mazeGen.rules")).buildDataSource());
        this.addManagedSegment(4, new TableDataSourceBlockPos(script.getStructureShift(), script::setStructureShift, null, null, null, IvTranslations.get("reccomplex.worldscript.mazeGen.shift.x"), IvTranslations.get("reccomplex.worldscript.mazeGen.shift.y"), IvTranslations.get("reccomplex.worldscript.mazeGen.shift.z")));
    }

    public WorldScriptMazeGenerator getScript() {
        return this.script;
    }

    public void setScript(WorldScriptMazeGenerator script) {
        this.script = script;
    }

    public TableDelegate getTableDelegate() {
        return this.delegate;
    }

    public void setTableDelegate(TableDelegate tableDelegate) {
        this.delegate = tableDelegate;
    }

    public TableNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(TableNavigator navigator) {
        this.navigator = navigator;
    }

    @Override
    public int numberOfSegments() {
        return 6;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: {
                return 1;
            }
            case 5: {
                return 3;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                TableCellString cell = new TableCellString("mazeID", this.script.getMazeID());
                cell.setShowsValidityState(true);
                cell.setValidityState(MazeGeneration.idValidity((String)cell.getPropertyValue()));
                cell.addPropertyConsumer(mazeID -> {
                    this.script.setMazeID((String)mazeID);
                    cell.setValidityState(MazeGeneration.idValidity(mazeID));
                });
                return new TitledCell(IvTranslations.get("reccomplex.maze.id"), cell);
            }
            case 5: {
                switch (index) {
                    case 0: {
                        TableCellInteger cell = new TableCellInteger("roomSizeX", this.script.getRoomSize()[0], 1, 64);
                        cell.addPropertyConsumer(this.roomSizeConsumer(0));
                        return new TitledCell(IvTranslations.get("reccomplex.maze.rooms.size.x"), cell);
                    }
                    case 1: {
                        TableCellInteger cell = new TableCellInteger("roomSizeY", this.script.getRoomSize()[1], 1, 64);
                        cell.addPropertyConsumer(this.roomSizeConsumer(1));
                        return new TitledCell(IvTranslations.get("reccomplex.maze.rooms.size.y"), cell);
                    }
                    case 2: {
                        TableCellInteger cell = new TableCellInteger("roomSizeZ", this.script.getRoomSize()[2], 1, 64);
                        cell.addPropertyConsumer(this.roomSizeConsumer(2));
                        return new TitledCell(IvTranslations.get("reccomplex.maze.rooms.size.z"), cell);
                    }
                }
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }

    private Consumer<Integer> roomSizeConsumer(int index) {
        return val -> {
            int[] size = this.script.getRoomSize();
            size[index] = val;
            this.script.setRoomSize(size);
        };
    }
}

